/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.memcache.binary;

import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.handler.codec.memcache.AbstractMemcacheObjectEncoder;
import org.spark_project.io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;

public abstract class AbstractBinaryMemcacheEncoder<M extends BinaryMemcacheMessage>
extends AbstractMemcacheObjectEncoder<M> {
    private static final int MINIMUM_HEADER_SIZE = 24;

    @Override
    protected ByteBuf encodeMessage(ChannelHandlerContext ctx, M msg) {
        ByteBuf buf = ctx.alloc().buffer(24 + msg.extrasLength() + msg.keyLength());
        this.encodeHeader(buf, msg);
        AbstractBinaryMemcacheEncoder.encodeExtras(buf, msg.extras());
        AbstractBinaryMemcacheEncoder.encodeKey(buf, msg.key());
        return buf;
    }

    private static void encodeExtras(ByteBuf buf, ByteBuf extras2) {
        if (extras2 == null || !extras2.isReadable()) {
            return;
        }
        buf.writeBytes(extras2);
    }

    private static void encodeKey(ByteBuf buf, ByteBuf key) {
        if (key == null || !key.isReadable()) {
            return;
        }
        buf.writeBytes(key);
    }

    protected abstract void encodeHeader(ByteBuf var1, M var2);
}

