/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.http2;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.channel.ChannelHandler;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.handler.codec.base64.Base64;
import org.spark_project.io.netty.handler.codec.base64.Base64Dialect;
import org.spark_project.io.netty.handler.codec.http.FullHttpResponse;
import org.spark_project.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import org.spark_project.io.netty.handler.codec.http.HttpRequest;
import org.spark_project.io.netty.handler.codec.http2.Http2CodecUtil;
import org.spark_project.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.spark_project.io.netty.handler.codec.http2.Http2FrameCodec;
import org.spark_project.io.netty.handler.codec.http2.Http2Settings;
import org.spark_project.io.netty.util.CharsetUtil;
import org.spark_project.io.netty.util.ReferenceCountUtil;
import org.spark_project.io.netty.util.collection.CharObjectMap;
import org.spark_project.io.netty.util.internal.ObjectUtil;

public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;

    public Http2ClientUpgradeCodec(Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(null, frameCodec, upgradeToHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(handlerName, (Http2ConnectionHandler)frameCodec, upgradeToHandler);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this((String)null, connectionHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        this(handlerName, connectionHandler, (ChannelHandler)connectionHandler);
    }

    private Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler upgradeToHandler) {
        this.handlerName = handlerName;
        this.connectionHandler = ObjectUtil.checkNotNull(connectionHandler, "connectionHandler");
        this.upgradeToHandler = ObjectUtil.checkNotNull(upgradeToHandler, "upgradeToHandler");
    }

    @Override
    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        CharSequence settingsValue = this.getSettingsHeaderValue(ctx);
        upgradeRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, (Object)settingsValue);
        return UPGRADE_HEADERS;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        ctx.pipeline().addAfter(ctx.name(), this.handlerName, this.upgradeToHandler);
        this.connectionHandler.onHttpClientUpgrade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getSettingsHeaderValue(ChannelHandlerContext ctx) {
        String string2;
        ByteBuf buf = null;
        ByteBuf encodedBuf = null;
        try {
            Http2Settings settings2 = this.connectionHandler.decoder().localSettings();
            int payloadLength = 6 * settings2.size();
            buf = ctx.alloc().buffer(payloadLength);
            for (CharObjectMap.PrimitiveEntry entry2 : settings2.entries()) {
                buf.writeChar(entry2.key());
                buf.writeInt(((Long)entry2.value()).intValue());
            }
            encodedBuf = Base64.encode(buf, Base64Dialect.URL_SAFE);
            string2 = encodedBuf.toString(CharsetUtil.UTF_8);
        }
        catch (Throwable throwable2) {
            ReferenceCountUtil.release(buf);
            ReferenceCountUtil.release(encodedBuf);
            throw throwable2;
        }
        ReferenceCountUtil.release(buf);
        ReferenceCountUtil.release(encodedBuf);
        return string2;
    }
}

