/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.http2;

import java.util.Arrays;
import java.util.Map;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.handler.codec.http2.HpackHeaderField;
import org.spark_project.io.netty.handler.codec.http2.HpackHuffmanEncoder;
import org.spark_project.io.netty.handler.codec.http2.HpackStaticTable;
import org.spark_project.io.netty.handler.codec.http2.HpackUtil;
import org.spark_project.io.netty.handler.codec.http2.Http2CodecUtil;
import org.spark_project.io.netty.handler.codec.http2.Http2Error;
import org.spark_project.io.netty.handler.codec.http2.Http2Exception;
import org.spark_project.io.netty.handler.codec.http2.Http2Headers;
import org.spark_project.io.netty.handler.codec.http2.Http2HeadersEncoder;
import org.spark_project.io.netty.util.AsciiString;
import org.spark_project.io.netty.util.CharsetUtil;
import org.spark_project.io.netty.util.internal.MathUtil;

final class HpackEncoder {
    private final HeaderEntry[] headerFields;
    private final HeaderEntry head = new HeaderEntry(-1, AsciiString.EMPTY_STRING, AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
    private final HpackHuffmanEncoder hpackHuffmanEncoder = new HpackHuffmanEncoder();
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    public HpackEncoder(boolean ignoreMaxHeaderListSize) {
        this(ignoreMaxHeaderListSize, 16);
    }

    public HpackEncoder(boolean ignoreMaxHeaderListSize, int arraySizeHint) {
        this.ignoreMaxHeaderListSize = ignoreMaxHeaderListSize;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 8192L;
        this.headerFields = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(arraySizeHint, 128)))];
        this.hashMask = (byte)(this.headerFields.length - 1);
        this.head.before = this.head.after = this.head;
    }

    public void encodeHeaders(int streamId, ByteBuf out, Http2Headers headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(out, headers, sensitivityDetector);
        } else {
            this.encodeHeadersEnforceMaxHeaderListSize(streamId, out, headers, sensitivityDetector);
        }
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int streamId, ByteBuf out, Http2Headers headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        long headerSize = 0L;
        for (Map.Entry<CharSequence, CharSequence> header : headers) {
            CharSequence value2;
            CharSequence name = header.getKey();
            if ((headerSize += HpackHeaderField.sizeOf(name, value2 = header.getValue())) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(out, headers, sensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf out, Http2Headers headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        for (Map.Entry<CharSequence, CharSequence> header : headers) {
            CharSequence name = header.getKey();
            CharSequence value2 = header.getValue();
            this.encodeHeader(out, name, value2, sensitivityDetector.isSensitive(name, value2), HpackHeaderField.sizeOf(name, value2));
        }
    }

    private void encodeHeader(ByteBuf out, CharSequence name, CharSequence value2, boolean sensitive, long headerSize) {
        if (sensitive) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value2, HpackUtil.IndexType.NEVER, nameIndex);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            int staticTableIndex = HpackStaticTable.getIndex(name, value2);
            if (staticTableIndex == -1) {
                int nameIndex = HpackStaticTable.getIndex(name);
                this.encodeLiteral(out, name, value2, HpackUtil.IndexType.NONE, nameIndex);
            } else {
                HpackEncoder.encodeInteger(out, 128, 7, staticTableIndex);
            }
            return;
        }
        if (headerSize > this.maxHeaderTableSize) {
            int nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value2, HpackUtil.IndexType.NONE, nameIndex);
            return;
        }
        HeaderEntry headerField = this.getEntry(name, value2);
        if (headerField != null) {
            int index = this.getIndex(headerField.index) + HpackStaticTable.length;
            HpackEncoder.encodeInteger(out, 128, 7, index);
        } else {
            int staticTableIndex = HpackStaticTable.getIndex(name, value2);
            if (staticTableIndex != -1) {
                HpackEncoder.encodeInteger(out, 128, 7, staticTableIndex);
            } else {
                this.ensureCapacity(headerSize);
                this.encodeLiteral(out, name, value2, HpackUtil.IndexType.INCREMENTAL, this.getNameIndex(name));
                this.add(name, value2, headerSize);
            }
        }
    }

    public void setMaxHeaderTableSize(ByteBuf out, long maxHeaderTableSize) throws Http2Exception {
        if (maxHeaderTableSize < 0L || maxHeaderTableSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderTableSize);
        }
        if (this.maxHeaderTableSize == maxHeaderTableSize) {
            return;
        }
        this.maxHeaderTableSize = maxHeaderTableSize;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(out, 32, 5, maxHeaderTableSize);
    }

    public long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public void setMaxHeaderListSize(long maxHeaderListSize) throws Http2Exception {
        if (maxHeaderListSize < 0L || maxHeaderListSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderListSize);
        }
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private static void encodeInteger(ByteBuf out, int mask, int n, int i) {
        HpackEncoder.encodeInteger(out, mask, n, (long)i);
    }

    private static void encodeInteger(ByteBuf out, int mask, int n, long i) {
        assert (n >= 0 && n <= 8) : "N: " + n;
        int nbits = 255 >>> 8 - n;
        if (i < (long)nbits) {
            out.writeByte((int)((long)mask | i));
        } else {
            out.writeByte(mask | nbits);
            long length = i - (long)nbits;
            while ((length & 0xFFFFFFFFFFFFFF80L) != 0L) {
                out.writeByte((int)(length & 0x7FL | 0x80L));
                length >>>= 7;
            }
            out.writeByte((int)length);
        }
    }

    private void encodeStringLiteral(ByteBuf out, CharSequence string2) {
        int huffmanLength = this.hpackHuffmanEncoder.getEncodedLength(string2);
        if (huffmanLength < string2.length()) {
            HpackEncoder.encodeInteger(out, 128, 7, huffmanLength);
            this.hpackHuffmanEncoder.encode(out, string2);
        } else {
            HpackEncoder.encodeInteger(out, 0, 7, string2.length());
            if (string2 instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)string2;
                out.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                out.writeCharSequence(string2, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf out, CharSequence name, CharSequence value2, HpackUtil.IndexType indexType, int nameIndex) {
        boolean nameIndexValid = nameIndex != -1;
        switch (indexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(out, 64, 6, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(out, 0, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(out, 16, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!nameIndexValid) {
            this.encodeStringLiteral(out, name);
        }
        this.encodeStringLiteral(out, value2);
    }

    private int getNameIndex(CharSequence name) {
        int index = HpackStaticTable.getIndex(name);
        if (index == -1 && (index = this.getIndex(name)) >= 0) {
            index += HpackStaticTable.length;
        }
        return index;
    }

    private void ensureCapacity(long headerSize) {
        int index;
        while (this.maxHeaderTableSize - this.size < headerSize && (index = this.length()) != 0) {
            this.remove();
        }
    }

    int length() {
        return this.size == 0L ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    long size() {
        return this.size;
    }

    HpackHeaderField getHeaderField(int index) {
        HeaderEntry entry2 = this.head;
        while (index-- >= 0) {
            entry2 = entry2.before;
        }
        return entry2;
    }

    private HeaderEntry getEntry(CharSequence name, CharSequence value2) {
        if (this.length() == 0 || name == null || value2 == null) {
            return null;
        }
        int h = AsciiString.hashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.headerFields[i];
        while (e != null) {
            if (e.hash == h && (HpackUtil.equalsConstantTime(name, e.name) & HpackUtil.equalsConstantTime(value2, e.value)) != 0) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private int getIndex(CharSequence name) {
        if (this.length() == 0 || name == null) {
            return -1;
        }
        int h = AsciiString.hashCode(name);
        int i = this.index(h);
        HeaderEntry e = this.headerFields[i];
        while (e != null) {
            if (e.hash == h && HpackUtil.equalsConstantTime(name, e.name) != 0) {
                return this.getIndex(e.index);
            }
            e = e.next;
        }
        return -1;
    }

    private int getIndex(int index) {
        return index == -1 ? -1 : index - this.head.before.index + 1;
    }

    private void add(CharSequence name, CharSequence value2, long headerSize) {
        HeaderEntry e;
        if (headerSize > this.maxHeaderTableSize) {
            this.clear();
            return;
        }
        while (this.maxHeaderTableSize - this.size < headerSize) {
            this.remove();
        }
        int h = AsciiString.hashCode(name);
        int i = this.index(h);
        HeaderEntry old = this.headerFields[i];
        this.headerFields[i] = e = new HeaderEntry(h, name, value2, this.head.before.index - 1, old);
        e.addBefore(this.head);
        this.size += headerSize;
    }

    private HpackHeaderField remove() {
        HeaderEntry prev;
        if (this.size == 0L) {
            return null;
        }
        HeaderEntry eldest = this.head.after;
        int h = eldest.hash;
        int i = this.index(h);
        HeaderEntry e = prev = this.headerFields[i];
        while (e != null) {
            HeaderEntry next2 = e.next;
            if (e == eldest) {
                if (prev == eldest) {
                    this.headerFields[i] = next2;
                } else {
                    prev.next = next2;
                }
                eldest.remove();
                this.size -= (long)eldest.size();
                return eldest;
            }
            prev = e;
            e = next2;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0L;
    }

    private int index(int h) {
        return h & this.hashMask;
    }

    private static final class HeaderEntry
    extends HpackHeaderField {
        HeaderEntry before;
        HeaderEntry after;
        HeaderEntry next;
        int hash;
        int index;

        HeaderEntry(int hash2, CharSequence name, CharSequence value2, int index, HeaderEntry next2) {
            super(name, value2);
            this.index = index;
            this.hash = hash2;
            this.next = next2;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.before = null;
            this.after = null;
            this.next = null;
        }

        private void addBefore(HeaderEntry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

