/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.http.websocketx;

import org.spark_project.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.spark_project.io.netty.handler.codec.http.FullHttpRequest;
import org.spark_project.io.netty.handler.codec.http.FullHttpResponse;
import org.spark_project.io.netty.handler.codec.http.HttpHeaderNames;
import org.spark_project.io.netty.handler.codec.http.HttpHeaderValues;
import org.spark_project.io.netty.handler.codec.http.HttpHeaders;
import org.spark_project.io.netty.handler.codec.http.HttpResponseStatus;
import org.spark_project.io.netty.handler.codec.http.HttpVersion;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.spark_project.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.spark_project.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker08
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_08_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;
    private final boolean allowMaskMismatch;

    public WebSocketServerHandshaker08(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshaker08(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        super(WebSocketVersion.V08, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        String key;
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        if (headers != null) {
            res.headers().add(headers);
        }
        if ((key = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY)) == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_08_ACCEPT_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        String accept2 = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 08 server handshake key: {}, response: {}", (Object)key, (Object)accept2);
        }
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)accept2);
        String subprotocols = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)subprotocols);
                }
            } else {
                res.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)selectedSubprotocol);
            }
        }
        return res;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket08FrameDecoder(true, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket08FrameEncoder(false);
    }
}

