/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.http.cookie;

import org.spark_project.io.netty.handler.codec.http.cookie.CookieUtil;

public abstract class CookieEncoder {
    protected final boolean strict;

    protected CookieEncoder(boolean strict2) {
        this.strict = strict2;
    }

    protected void validateCookie(String name, String value2) {
        if (this.strict) {
            int pos2 = CookieUtil.firstInvalidCookieNameOctet(name);
            if (pos2 >= 0) {
                throw new IllegalArgumentException("Cookie name contains an invalid char: " + name.charAt(pos2));
            }
            CharSequence unwrappedValue = CookieUtil.unwrapValue(value2);
            if (unwrappedValue == null) {
                throw new IllegalArgumentException("Cookie value wrapping quotes are not balanced: " + value2);
            }
            pos2 = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue);
            if (pos2 >= 0) {
                throw new IllegalArgumentException("Cookie value contains an invalid char: " + value2.charAt(pos2));
            }
        }
    }
}

