/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.handler.codec.http;

import org.spark_project.io.netty.channel.embedded.EmbeddedChannel;
import org.spark_project.io.netty.handler.codec.compression.ZlibCodecFactory;
import org.spark_project.io.netty.handler.codec.compression.ZlibWrapper;
import org.spark_project.io.netty.handler.codec.http.HttpContentDecoder;
import org.spark_project.io.netty.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean strict2) {
        this.strict = strict2;
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(wrapper));
        }
        return null;
    }
}

