/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.channel.nio;

import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.spark_project.io.netty.channel.DefaultSelectStrategyFactory;
import org.spark_project.io.netty.channel.EventLoop;
import org.spark_project.io.netty.channel.MultithreadEventLoopGroup;
import org.spark_project.io.netty.channel.SelectStrategyFactory;
import org.spark_project.io.netty.channel.nio.NioEventLoop;
import org.spark_project.io.netty.util.concurrent.EventExecutor;
import org.spark_project.io.netty.util.concurrent.EventExecutorChooserFactory;
import org.spark_project.io.netty.util.concurrent.RejectedExecutionHandler;
import org.spark_project.io.netty.util.concurrent.RejectedExecutionHandlers;

public class NioEventLoopGroup
extends MultithreadEventLoopGroup {
    public NioEventLoopGroup() {
        this(0);
    }

    public NioEventLoopGroup(int nThreads) {
        this(nThreads, (Executor)null);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        this(nThreads, threadFactory, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, Executor executor) {
        this(nThreads, executor, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider) {
        this(nThreads, threadFactory, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, threadFactory, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, SelectorProvider selectorProvider) {
        this(nThreads, executor, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, Executor executor, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, executor, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, executor, chooserFactory, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(nThreads, executor, chooserFactory, selectorProvider, selectStrategyFactory, rejectedExecutionHandler);
    }

    public void setIoRatio(int ioRatio) {
        for (EventExecutor e : this) {
            ((NioEventLoop)e).setIoRatio(ioRatio);
        }
    }

    public void rebuildSelectors() {
        for (EventExecutor e : this) {
            ((NioEventLoop)e).rebuildSelector();
        }
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... args2) throws Exception {
        return new NioEventLoop(this, executor, (SelectorProvider)args2[0], ((SelectStrategyFactory)args2[1]).newSelectStrategy(), (RejectedExecutionHandler)args2[2]);
    }
}

