/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.channel.local;

import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import org.spark_project.io.netty.channel.AbstractServerChannel;
import org.spark_project.io.netty.channel.ChannelConfig;
import org.spark_project.io.netty.channel.ChannelPipeline;
import org.spark_project.io.netty.channel.DefaultChannelConfig;
import org.spark_project.io.netty.channel.EventLoop;
import org.spark_project.io.netty.channel.PreferHeapByteBufAllocator;
import org.spark_project.io.netty.channel.SingleThreadEventLoop;
import org.spark_project.io.netty.channel.local.LocalAddress;
import org.spark_project.io.netty.channel.local.LocalChannel;
import org.spark_project.io.netty.channel.local.LocalChannelRegistry;
import org.spark_project.io.netty.util.concurrent.SingleThreadEventExecutor;

public class LocalServerChannel
extends AbstractServerChannel {
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
    private final Runnable shutdownHook = new Runnable(){

        @Override
        public void run() {
            LocalServerChannel.this.unsafe().close(LocalServerChannel.this.unsafe().voidPromise());
        }
    };
    private volatile int state;
    private volatile LocalAddress localAddress;
    private volatile boolean acceptInProgress;

    public LocalServerChannel() {
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    @Override
    protected boolean isCompatible(EventLoop loop2) {
        return loop2 instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected void doRegister() throws Exception {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).addShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, localAddress);
        this.state = 1;
    }

    @Override
    protected void doClose() throws Exception {
        if (this.state <= 1) {
            if (this.localAddress != null) {
                LocalChannelRegistry.unregister(this.localAddress);
                this.localAddress = null;
            }
            this.state = 2;
        }
    }

    @Override
    protected void doDeregister() throws Exception {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).removeShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBeginRead() throws Exception {
        Object m;
        if (this.acceptInProgress) {
            return;
        }
        Queue<Object> inboundBuffer = this.inboundBuffer;
        if (inboundBuffer.isEmpty()) {
            this.acceptInProgress = true;
            return;
        }
        ChannelPipeline pipeline = this.pipeline();
        while ((m = inboundBuffer.poll()) != null) {
            pipeline.fireChannelRead(m);
        }
        pipeline.fireChannelReadComplete();
    }

    LocalChannel serve(LocalChannel peer) {
        final LocalChannel child = this.newLocalChannel(peer);
        if (this.eventLoop().inEventLoop()) {
            this.serve0(child);
        } else {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    LocalServerChannel.this.serve0(child);
                }
            });
        }
        return child;
    }

    protected LocalChannel newLocalChannel(LocalChannel peer) {
        return new LocalChannel(this, peer);
    }

    private void serve0(LocalChannel child) {
        this.inboundBuffer.add(child);
        if (this.acceptInProgress) {
            Object m;
            this.acceptInProgress = false;
            ChannelPipeline pipeline = this.pipeline();
            while ((m = this.inboundBuffer.poll()) != null) {
                pipeline.fireChannelRead(m);
            }
            pipeline.fireChannelReadComplete();
        }
    }
}

