/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.io.netty.channel;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.ByteBufHolder;
import org.spark_project.io.netty.buffer.Unpooled;
import org.spark_project.io.netty.channel.AbstractChannel;
import org.spark_project.io.netty.channel.Channel;
import org.spark_project.io.netty.channel.ChannelPipeline;
import org.spark_project.io.netty.channel.ChannelProgressivePromise;
import org.spark_project.io.netty.channel.ChannelPromise;
import org.spark_project.io.netty.channel.FileRegion;
import org.spark_project.io.netty.channel.VoidChannelPromise;
import org.spark_project.io.netty.util.Recycler;
import org.spark_project.io.netty.util.ReferenceCountUtil;
import org.spark_project.io.netty.util.concurrent.FastThreadLocal;
import org.spark_project.io.netty.util.internal.InternalThreadLocalMap;
import org.spark_project.io.netty.util.internal.PromiseNotificationUtil;
import org.spark_project.io.netty.util.internal.SystemPropertyUtil;
import org.spark_project.io.netty.util.internal.logging.InternalLogger;
import org.spark_project.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt("org.spark_project.io.netty.transport.outboundBufferEntrySizeOverhead", 96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new FastThreadLocal<ByteBuffer[]>(){

        @Override
        protected ByteBuffer[] initialValue() throws Exception {
            return new ByteBuffer[1024];
        }
    };
    private final Channel channel;
    private Entry flushedEntry;
    private Entry unflushedEntry;
    private Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel channel) {
        this.channel = channel;
    }

    public void addMessage(Object msg, int size2, ChannelPromise promise) {
        Entry entry2 = Entry.newInstance(msg, size2, ChannelOutboundBuffer.total(msg), promise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
            this.tailEntry = entry2;
        } else {
            Entry tail = this.tailEntry;
            tail.next = entry2;
            this.tailEntry = entry2;
        }
        if (this.unflushedEntry == null) {
            this.unflushedEntry = entry2;
        }
        this.incrementPendingOutboundBytes(entry2.pendingSize, false);
    }

    public void addFlush() {
        Entry entry2 = this.unflushedEntry;
        if (entry2 != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = entry2;
            }
            do {
                ++this.flushed;
                if (entry2.promise.setUncancellable()) continue;
                int pending = entry2.cancel();
                this.decrementPendingOutboundBytes(pending, false, true);
            } while ((entry2 = entry2.next) != null);
            this.unflushedEntry = null;
        }
    }

    void incrementPendingOutboundBytes(long size2) {
        this.incrementPendingOutboundBytes(size2, true);
    }

    private void incrementPendingOutboundBytes(long size2, boolean invokeLater) {
        if (size2 == 0L) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, size2);
        if (newWriteBufferSize > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(invokeLater);
        }
    }

    void decrementPendingOutboundBytes(long size2) {
        this.decrementPendingOutboundBytes(size2, true, true);
    }

    private void decrementPendingOutboundBytes(long size2, boolean invokeLater, boolean notifyWritability) {
        if (size2 == 0L) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -size2);
        if (notifyWritability && newWriteBufferSize < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(invokeLater);
        }
    }

    private static long total(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).count();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1L;
    }

    public Object current() {
        Entry entry2 = this.flushedEntry;
        if (entry2 == null) {
            return null;
        }
        return entry2.msg;
    }

    public void progress(long amount) {
        Entry e = this.flushedEntry;
        assert (e != null);
        ChannelPromise p = e.promise;
        if (p instanceof ChannelProgressivePromise) {
            long progress;
            e.progress = progress = e.progress + amount;
            ((ChannelProgressivePromise)p).tryProgress(progress, e.total);
        }
    }

    public boolean remove() {
        Entry e = this.flushedEntry;
        if (e == null) {
            this.clearNioBuffers();
            return false;
        }
        Object msg = e.msg;
        ChannelPromise promise = e.promise;
        int size2 = e.pendingSize;
        this.removeEntry(e);
        if (!e.cancelled) {
            ReferenceCountUtil.safeRelease(msg);
            ChannelOutboundBuffer.safeSuccess(promise);
            this.decrementPendingOutboundBytes(size2, false, true);
        }
        e.recycle();
        return true;
    }

    public boolean remove(Throwable cause) {
        return this.remove0(cause, true);
    }

    private boolean remove0(Throwable cause, boolean notifyWritability) {
        Entry e = this.flushedEntry;
        if (e == null) {
            this.clearNioBuffers();
            return false;
        }
        Object msg = e.msg;
        ChannelPromise promise = e.promise;
        int size2 = e.pendingSize;
        this.removeEntry(e);
        if (!e.cancelled) {
            ReferenceCountUtil.safeRelease(msg);
            ChannelOutboundBuffer.safeFail(promise, cause);
            this.decrementPendingOutboundBytes(size2, false, notifyWritability);
        }
        e.recycle();
        return true;
    }

    private void removeEntry(Entry e) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (e == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = e.next;
        }
    }

    public void removeBytes(long writtenBytes) {
        block5: {
            int readerIndex;
            ByteBuf buf;
            while (true) {
                Object msg;
                if (!((msg = this.current()) instanceof ByteBuf)) {
                    assert (writtenBytes == 0L);
                    break block5;
                }
                buf = (ByteBuf)msg;
                readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if ((long)readableBytes > writtenBytes) break;
                if (writtenBytes != 0L) {
                    this.progress(readableBytes);
                    writtenBytes -= (long)readableBytes;
                }
                this.remove();
            }
            if (writtenBytes != 0L) {
                buf.readerIndex(readerIndex + (int)writtenBytes);
                this.progress(writtenBytes);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int count = this.nioBufferCount;
        if (count > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, count, null);
        }
    }

    public ByteBuffer[] nioBuffers() {
        long nioBufferSize = 0L;
        int nioBufferCount = 0;
        InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] nioBuffers = NIO_BUFFERS.get(threadLocalMap);
        Entry entry2 = this.flushedEntry;
        while (this.isFlushedEntry(entry2) && entry2.msg instanceof ByteBuf) {
            if (!entry2.cancelled) {
                ByteBuf buf = (ByteBuf)entry2.msg;
                int readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if (readableBytes > 0) {
                    int neededSpace;
                    if ((long)(Integer.MAX_VALUE - readableBytes) < nioBufferSize) break;
                    nioBufferSize += (long)readableBytes;
                    int count = entry2.count;
                    if (count == -1) {
                        entry2.count = count = buf.nioBufferCount();
                    }
                    if ((neededSpace = nioBufferCount + count) > nioBuffers.length) {
                        nioBuffers = ChannelOutboundBuffer.expandNioBufferArray(nioBuffers, neededSpace, nioBufferCount);
                        NIO_BUFFERS.set(threadLocalMap, nioBuffers);
                    }
                    if (count == 1) {
                        ByteBuffer nioBuf = entry2.buf;
                        if (nioBuf == null) {
                            entry2.buf = nioBuf = buf.internalNioBuffer(readerIndex, readableBytes);
                        }
                        nioBuffers[nioBufferCount++] = nioBuf;
                    } else {
                        ByteBuffer[] nioBufs = entry2.bufs;
                        if (nioBufs == null) {
                            nioBufs = buf.nioBuffers();
                            entry2.bufs = nioBufs;
                        }
                        nioBufferCount = ChannelOutboundBuffer.fillBufferArray(nioBufs, nioBuffers, nioBufferCount);
                    }
                }
            }
            entry2 = entry2.next;
        }
        this.nioBufferCount = nioBufferCount;
        this.nioBufferSize = nioBufferSize;
        return nioBuffers;
    }

    private static int fillBufferArray(ByteBuffer[] nioBufs, ByteBuffer[] nioBuffers, int nioBufferCount) {
        for (ByteBuffer nioBuf : nioBufs) {
            if (nioBuf == null) break;
            nioBuffers[nioBufferCount++] = nioBuf;
        }
        return nioBufferCount;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] array2, int neededSpace, int size2) {
        int newCapacity = array2.length;
        do {
            if ((newCapacity <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (neededSpace > newCapacity);
        ByteBuffer[] newArray = new ByteBuffer[newCapacity];
        System.arraycopy(array2, 0, newArray, 0, size2);
        return newArray;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public boolean getUserDefinedWritability(int index) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(index)) == 0;
    }

    public void setUserDefinedWritability(int index, boolean writable) {
        if (writable) {
            this.setUserDefinedWritability(index);
        } else {
            this.clearUserDefinedWritability(index);
        }
    }

    private void setUserDefinedWritability(int index) {
        block1: {
            int newValue;
            int oldValue;
            int mask = ~ChannelOutboundBuffer.writabilityMask(index);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue & mask)) {
            }
            if (oldValue == 0 || newValue != 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private void clearUserDefinedWritability(int index) {
        block1: {
            int newValue;
            int oldValue;
            int mask = ChannelOutboundBuffer.writabilityMask(index);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue | mask)) {
            }
            if (oldValue != 0 || newValue == 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private static int writabilityMask(int index) {
        if (index < 1 || index > 31) {
            throw new IllegalArgumentException("index: " + index + " (expected: 1~31)");
        }
        return 1 << index;
    }

    private void setWritable(boolean invokeLater) {
        block1: {
            int newValue;
            int oldValue;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue & 0xFFFFFFFE)) {
            }
            if (oldValue == 0 || newValue != 0) break block1;
            this.fireChannelWritabilityChanged(invokeLater);
        }
    }

    private void setUnwritable(boolean invokeLater) {
        block1: {
            int newValue;
            int oldValue;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue | 1)) {
            }
            if (oldValue != 0 || newValue == 0) break block1;
            this.fireChannelWritabilityChanged(invokeLater);
        }
    }

    private void fireChannelWritabilityChanged(boolean invokeLater) {
        final ChannelPipeline pipeline = this.channel.pipeline();
        if (invokeLater) {
            Runnable task2 = this.fireChannelWritabilityChangedTask;
            if (task2 == null) {
                this.fireChannelWritabilityChangedTask = task2 = new Runnable(){

                    @Override
                    public void run() {
                        pipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.channel.eventLoop().execute(task2);
        } else {
            pipeline.fireChannelWritabilityChanged();
        }
    }

    public int size() {
        return this.flushed;
    }

    public boolean isEmpty() {
        return this.flushed == 0;
    }

    void failFlushed(Throwable cause, boolean notify) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(cause, notify)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(final Throwable cause, final boolean allowChannelOpen) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelOutboundBuffer.this.close(cause, allowChannelOpen);
                }
            });
            return;
        }
        this.inFail = true;
        if (!allowChannelOpen && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (Entry e = this.unflushedEntry; e != null; e = e.recycleAndGetNext()) {
                int size2 = e.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -size2);
                if (e.cancelled) continue;
                ReferenceCountUtil.safeRelease(e.msg);
                ChannelOutboundBuffer.safeFail(e.promise, cause);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    void close(ClosedChannelException cause) {
        this.close(cause, false);
    }

    private static void safeSuccess(ChannelPromise promise) {
        PromiseNotificationUtil.trySuccess(promise, null, promise instanceof VoidChannelPromise ? null : logger);
    }

    private static void safeFail(ChannelPromise promise, Throwable cause) {
        PromiseNotificationUtil.tryFailure(promise, cause, promise instanceof VoidChannelPromise ? null : logger);
    }

    @Deprecated
    public void recycle() {
    }

    public long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public long bytesBeforeUnwritable() {
        long bytes2 = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (bytes2 > 0L) {
            return this.isWritable() ? bytes2 : 0L;
        }
        return 0L;
    }

    public long bytesBeforeWritable() {
        long bytes2 = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark();
        if (bytes2 > 0L) {
            return this.isWritable() ? 0L : bytes2;
        }
        return 0L;
    }

    public void forEachFlushedMessage(MessageProcessor processor) throws Exception {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        Entry entry2 = this.flushedEntry;
        if (entry2 == null) {
            return;
        }
        do {
            if (entry2.cancelled || processor.processMessage(entry2.msg)) continue;
            return;
        } while (this.isFlushedEntry(entry2 = entry2.next));
    }

    private boolean isFlushedEntry(Entry e) {
        return e != null && e != this.unflushedEntry;
    }

    static final class Entry {
        private static final Recycler<Entry> RECYCLER = new Recycler<Entry>(){

            @Override
            protected Entry newObject(Recycler.Handle<Entry> handle) {
                return new Entry(handle);
            }
        };
        private final Recycler.Handle<Entry> handle;
        Entry next;
        Object msg;
        ByteBuffer[] bufs;
        ByteBuffer buf;
        ChannelPromise promise;
        long progress;
        long total;
        int pendingSize;
        int count = -1;
        boolean cancelled;

        private Entry(Recycler.Handle<Entry> handle) {
            this.handle = handle;
        }

        static Entry newInstance(Object msg, int size2, long total2, ChannelPromise promise) {
            Entry entry2 = RECYCLER.get();
            entry2.msg = msg;
            entry2.pendingSize = size2 + CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD;
            entry2.total = total2;
            entry2.promise = promise;
            return entry2;
        }

        int cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                int pSize = this.pendingSize;
                ReferenceCountUtil.safeRelease(this.msg);
                this.msg = Unpooled.EMPTY_BUFFER;
                this.pendingSize = 0;
                this.total = 0L;
                this.progress = 0L;
                this.bufs = null;
                this.buf = null;
                return pSize;
            }
            return 0;
        }

        void recycle() {
            this.next = null;
            this.bufs = null;
            this.buf = null;
            this.msg = null;
            this.promise = null;
            this.progress = 0L;
            this.total = 0L;
            this.pendingSize = 0;
            this.count = -1;
            this.cancelled = false;
            this.handle.recycle(this);
        }

        Entry recycleAndGetNext() {
            Entry next2 = this.next;
            this.recycle();
            return next2;
        }
    }

    public static interface MessageProcessor {
        public boolean processMessage(Object var1) throws Exception;
    }
}

