/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.reflect;

import java.util.Map;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.Beta;
import org.spark_project.guava.collect.ForwardingMap;
import org.spark_project.guava.collect.Maps;
import org.spark_project.guava.reflect.TypeToInstanceMap;
import org.spark_project.guava.reflect.TypeToken;

@Beta
public final class MutableTypeToInstanceMap<B>
extends ForwardingMap<TypeToken<? extends B>, B>
implements TypeToInstanceMap<B> {
    private final Map<TypeToken<? extends B>, B> backingMap = Maps.newHashMap();

    @Override
    @Nullable
    public <T extends B> T getInstance(Class<T> type) {
        return this.trustedGet(TypeToken.of(type));
    }

    @Override
    @Nullable
    public <T extends B> T putInstance(Class<T> type, @Nullable T value2) {
        return this.trustedPut(TypeToken.of(type), value2);
    }

    @Override
    @Nullable
    public <T extends B> T getInstance(TypeToken<T> type) {
        return this.trustedGet(type.rejectTypeVariables());
    }

    @Override
    @Nullable
    public <T extends B> T putInstance(TypeToken<T> type, @Nullable T value2) {
        return this.trustedPut(type.rejectTypeVariables(), value2);
    }

    @Override
    public B put(TypeToken<? extends B> key, B value2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    public void putAll(Map<? extends TypeToken<? extends B>, ? extends B> map2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    protected Map<TypeToken<? extends B>, B> delegate() {
        return this.backingMap;
    }

    @Nullable
    private <T extends B> T trustedPut(TypeToken<T> type, @Nullable T value2) {
        return (T)this.backingMap.put(type, value2);
    }

    @Nullable
    private <T extends B> T trustedGet(TypeToken<T> type) {
        return (T)this.backingMap.get(type);
    }
}

