/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.reflect;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.Beta;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.base.Splitter;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.collect.ImmutableSet;
import org.spark_project.guava.collect.ImmutableSortedSet;
import org.spark_project.guava.collect.Maps;
import org.spark_project.guava.collect.Ordering;
import org.spark_project.guava.reflect.Reflection;

@Beta
public final class ClassPath {
    private static final Logger logger = Logger.getLogger(ClassPath.class.getName());
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on(" ").omitEmptyStrings();
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final ImmutableSet<ResourceInfo> resources;

    private ClassPath(ImmutableSet<ResourceInfo> resources) {
        this.resources = resources;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        ImmutableSortedSet.Builder<Object> resources = new ImmutableSortedSet.Builder<Object>(Ordering.usingToString());
        for (Map.Entry entry2 : ClassPath.getClassPathEntries(classloader).entrySet()) {
            ClassPath.browse((URI)entry2.getKey(), (ClassLoader)entry2.getValue(), resources);
        }
        return new ClassPath(resources.build());
    }

    public ImmutableSet<ResourceInfo> getResources() {
        return this.resources;
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ResourceInfo resource : this.resources) {
            if (!(resource instanceof ClassInfo)) continue;
            builder.add((ClassInfo)resource);
        }
        return builder.build();
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses(String packageName) {
        Preconditions.checkNotNull(packageName);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(packageName)) continue;
            builder.add(classInfo);
        }
        return builder.build();
    }

    public ImmutableSet<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        Preconditions.checkNotNull(packageName);
        String packagePrefix = packageName + '.';
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            builder.add(classInfo);
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableMap<URI, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        LinkedHashMap<URI, ClassLoader> entries2 = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries2.putAll(ClassPath.getClassPathEntries(parent));
        }
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            for (URL entry2 : urlClassLoader.getURLs()) {
                URI uri;
                try {
                    uri = entry2.toURI();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                if (entries2.containsKey(uri)) continue;
                entries2.put(uri, classloader);
            }
        }
        return ImmutableMap.copyOf(entries2);
    }

    private static void browse(URI uri, ClassLoader classloader, ImmutableSet.Builder<ResourceInfo> resources) throws IOException {
        if (uri.getScheme().equals("file")) {
            ClassPath.browseFrom(new File(uri), classloader, resources);
        }
    }

    @VisibleForTesting
    static void browseFrom(File file, ClassLoader classloader, ImmutableSet.Builder<ResourceInfo> resources) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            ClassPath.browseDirectory(file, classloader, resources);
        } else {
            ClassPath.browseJar(file, classloader, resources);
        }
    }

    private static void browseDirectory(File directory, ClassLoader classloader, ImmutableSet.Builder<ResourceInfo> resources) {
        ClassPath.browseDirectory(directory, classloader, "", resources);
    }

    private static void browseDirectory(File directory, ClassLoader classloader, String packagePrefix, ImmutableSet.Builder<ResourceInfo> resources) {
        for (File f2 : directory.listFiles()) {
            String name = f2.getName();
            if (f2.isDirectory()) {
                ClassPath.browseDirectory(f2, classloader, packagePrefix + name + "/", resources);
                continue;
            }
            String resourceName = packagePrefix + name;
            resources.add((Object)ResourceInfo.of(resourceName, classloader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void browseJar(File file, ClassLoader classloader, ImmutableSet.Builder<ResourceInfo> resources) throws IOException {
        JarFile jarFile2;
        try {
            jarFile2 = new JarFile(file);
        }
        catch (IOException e) {
            return;
        }
        try {
            for (URI uri : ClassPath.getClassPathFromManifest(file, jarFile2.getManifest())) {
                ClassPath.browse(uri, classloader, resources);
            }
            Enumeration<JarEntry> entries2 = jarFile2.entries();
            while (entries2.hasMoreElements()) {
                JarEntry entry2 = entries2.nextElement();
                if (entry2.isDirectory() || entry2.getName().startsWith("META-INF/")) continue;
                resources.add((Object)ResourceInfo.of(entry2.getName(), classloader));
            }
        }
        finally {
            try {
                jarFile2.close();
            }
            catch (IOException ignored) {}
        }
    }

    @VisibleForTesting
    static ImmutableSet<URI> getClassPathFromManifest(File jarFile2, @Nullable Manifest manifest2) {
        if (manifest2 == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        String classpathAttribute = manifest2.getMainAttributes().getValue("Class-Path");
        if (classpathAttribute != null) {
            for (String path2 : CLASS_PATH_ATTRIBUTE_SEPARATOR.split(classpathAttribute)) {
                URI uri;
                try {
                    uri = ClassPath.getClassPathEntry(jarFile2, path2);
                }
                catch (URISyntaxException e) {
                    logger.warning("Invalid Class-Path entry: " + path2);
                    continue;
                }
                builder.add(uri);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static URI getClassPathEntry(File jarFile2, String path2) throws URISyntaxException {
        URI uri = new URI(path2);
        if (uri.isAbsolute()) {
            return uri;
        }
        return new File(jarFile2.getParentFile(), path2.replace('/', File.separatorChar)).toURI();
    }

    @VisibleForTesting
    static String getClassName(String filename) {
        int classNameEnd = filename.length() - CLASS_FILE_NAME_EXTENSION.length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    @Beta
    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String resourceName, ClassLoader loader2) {
            super(resourceName, loader2);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            return Reflection.getPackageName(this.className);
        }

        public String getSimpleName() {
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(packageName.length() + 1);
        }

        public String getName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    @Beta
    public static class ResourceInfo {
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(String resourceName, ClassLoader loader2) {
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION) && !resourceName.contains("$")) {
                return new ClassInfo(resourceName, loader2);
            }
            return new ResourceInfo(resourceName, loader2);
        }

        ResourceInfo(String resourceName, ClassLoader loader2) {
            this.resourceName = Preconditions.checkNotNull(resourceName);
            this.loader = Preconditions.checkNotNull(loader2);
        }

        public final URL url() {
            return Preconditions.checkNotNull(this.loader.getResource(this.resourceName), "Failed to load resource: %s", this.resourceName);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

