/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.primitives;

import java.util.Comparator;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;

@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    public static byte checkedCast(long value2) {
        byte result2 = (byte)value2;
        Preconditions.checkArgument((long)result2 == value2, "Out of range: %s", value2);
        return result2;
    }

    public static byte saturatedCast(long value2) {
        if (value2 > 127L) {
            return 127;
        }
        if (value2 < -128L) {
            return -128;
        }
        return (byte)value2;
    }

    public static int compare(byte a, byte b) {
        return a - b;
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        byte min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        byte max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max2) continue;
            max2 = array2[i];
        }
        return max2;
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] left, byte[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result2 = SignedBytes.compare(left[i], right[i]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }
    }
}

