/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;

@GwtCompatible
public final class Booleans {
    private Booleans() {
    }

    public static int hashCode(boolean value2) {
        return value2 ? 1231 : 1237;
    }

    public static int compare(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    public static boolean contains(boolean[] array2, boolean target) {
        for (boolean value2 : array2) {
            if (value2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(boolean[] array2, boolean target) {
        return Booleans.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(boolean[] array2, boolean target, int start2, int end) {
        for (int i = start2; i < end; ++i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array2, boolean[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array2.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array2[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array2, boolean target) {
        return Booleans.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(boolean[] array2, boolean target, int start2, int end) {
        for (int i = end - 1; i >= start2; --i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int length = 0;
        for (boolean[] array2 : arrays) {
            length += array2.length;
        }
        boolean[] result2 = new boolean[length];
        int pos2 = 0;
        for (boolean[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos2, array3.length);
            pos2 += array3.length;
        }
        return result2;
    }

    public static boolean[] ensureCapacity(boolean[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Booleans.copyOf(array2, minLength + padding) : array2;
    }

    private static boolean[] copyOf(boolean[] original, int length) {
        boolean[] copy2 = new boolean[length];
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, length));
        return copy2;
    }

    public static String join(String separator, boolean ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 7);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static boolean[] toArray(Collection<Boolean> collection) {
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        boolean[] array2 = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = (Boolean)Preconditions.checkNotNull(boxedArray[i]);
        }
        return array2;
    }

    public static List<Boolean> asList(boolean ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements RandomAccess,
    Serializable {
        final boolean[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        BooleanArrayAsList(boolean[] array2) {
            this(array2, 0, array2.length);
        }

        BooleanArrayAsList(boolean[] array2, int start2, int end) {
            this.array = array2;
            this.start = start2;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Boolean get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Boolean && Booleans.indexOf(this.array, (Boolean)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Boolean && (i = Booleans.indexOf(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Boolean && (i = Booleans.lastIndexOf(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Boolean set(int index, Boolean element) {
            Preconditions.checkElementIndex(index, this.size());
            boolean oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Boolean> subList(int fromIndex, int toIndex) {
            int size2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList that = (BooleanArrayAsList)object;
                int size2 = this.size();
                if (that.size() != size2) {
                    return false;
                }
                for (int i = 0; i < size2; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i = this.start; i < this.end; ++i) {
                result2 = 31 * result2 + Booleans.hashCode(this.array[i]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 7);
            builder.append(this.array[this.start] ? "[true" : "[false");
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(this.array[i] ? ", true" : ", false");
            }
            return builder.append(']').toString();
        }

        boolean[] toBooleanArray() {
            int size2 = this.size();
            boolean[] result2 = new boolean[size2];
            System.arraycopy(this.array, this.start, result2, 0, size2);
            return result2;
        }
    }

    private static enum LexicographicalComparator implements Comparator<boolean[]>
    {
        INSTANCE;


        @Override
        public int compare(boolean[] left, boolean[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result2 = Booleans.compare(left[i], right[i]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }
    }
}

