/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.spark_project.guava.annotations.Beta;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.io.LineBuffer;

@Beta
public final class LineReader {
    private final Readable readable;
    private final Reader reader;
    private final char[] buf = new char[4096];
    private final CharBuffer cbuf = CharBuffer.wrap(this.buf);
    private final Queue<String> lines = new LinkedList<String>();
    private final LineBuffer lineBuf = new LineBuffer(){

        @Override
        protected void handleLine(String line2, String end) {
            LineReader.this.lines.add(line2);
        }
    };

    public LineReader(Readable readable) {
        Preconditions.checkNotNull(readable);
        this.readable = readable;
        this.reader = readable instanceof Reader ? (Reader)readable : null;
    }

    public String readLine() throws IOException {
        while (this.lines.peek() == null) {
            int read2;
            this.cbuf.clear();
            int n = read2 = this.reader != null ? this.reader.read(this.buf, 0, this.buf.length) : this.readable.read(this.cbuf);
            if (read2 == -1) {
                this.lineBuf.finish();
                break;
            }
            this.lineBuf.add(this.buf, 0, read2);
        }
        return this.lines.poll();
    }
}

