/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.Beta;

@Beta
public final class CountingInputStream
extends FilterInputStream {
    private long count;
    private long mark = -1L;

    public CountingInputStream(@Nullable InputStream in) {
        super(in);
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int result2 = this.in.read();
        if (result2 != -1) {
            ++this.count;
        }
        return result2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result2 = this.in.read(b, off, len);
        if (result2 != -1) {
            this.count += (long)result2;
        }
        return result2;
    }

    @Override
    public long skip(long n) throws IOException {
        long result2 = this.in.skip(n);
        this.count += result2;
        return result2;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count = this.mark;
    }
}

