/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.io.CharStreams;
import org.spark_project.guava.io.Closer;

public abstract class CharSink {
    public abstract Writer openStream() throws IOException;

    public BufferedWriter openBufferedStream() throws IOException {
        Writer writer = this.openStream();
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void write(CharSequence charSequence) throws IOException {
        Preconditions.checkNotNull(charSequence);
        Closer closer = Closer.create();
        try {
            Writer out = closer.register(this.openStream());
            out.append(charSequence);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void writeLines(Iterable<? extends CharSequence> lines2) throws IOException {
        this.writeLines(lines2, System.getProperty("line.separator"));
    }

    public void writeLines(Iterable<? extends CharSequence> lines2, String lineSeparator) throws IOException {
        Preconditions.checkNotNull(lines2);
        Preconditions.checkNotNull(lineSeparator);
        Closer closer = Closer.create();
        try {
            BufferedWriter out = closer.register(this.openBufferedStream());
            for (CharSequence charSequence : lines2) {
                out.append(charSequence).append(lineSeparator);
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public long writeFrom(Readable readable) throws IOException {
        Preconditions.checkNotNull(readable);
        Closer closer = Closer.create();
        try {
            Writer out = closer.register(this.openStream());
            long l = CharStreams.copy(readable, (Appendable)out);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

