/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.hash;

import java.io.Serializable;
import java.util.zip.Checksum;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.base.Supplier;
import org.spark_project.guava.hash.AbstractByteHasher;
import org.spark_project.guava.hash.AbstractStreamingHashFunction;
import org.spark_project.guava.hash.HashCode;
import org.spark_project.guava.hash.HashCodes;
import org.spark_project.guava.hash.Hasher;

final class ChecksumHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final Supplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(Supplier<? extends Checksum> checksumSupplier, int bits, String toString2) {
        this.checksumSupplier = Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument(bits == 32 || bits == 64, "bits (%s) must be either 32 or 64", bits);
        this.bits = bits;
        this.toString = Preconditions.checkNotNull(toString2);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher(this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update(b);
        }

        @Override
        protected void update(byte[] bytes2, int off, int len) {
            this.checksum.update(bytes2, off, len);
        }

        @Override
        public HashCode hash() {
            long value2 = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCodes.fromInt((int)value2);
            }
            return HashCodes.fromLong(value2);
        }
    }
}

