/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.eventbus;

import java.lang.reflect.Method;
import java.util.Set;
import org.spark_project.guava.base.Throwables;
import org.spark_project.guava.cache.CacheBuilder;
import org.spark_project.guava.cache.CacheLoader;
import org.spark_project.guava.cache.LoadingCache;
import org.spark_project.guava.collect.HashMultimap;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.Multimap;
import org.spark_project.guava.eventbus.AllowConcurrentEvents;
import org.spark_project.guava.eventbus.EventHandler;
import org.spark_project.guava.eventbus.HandlerFindingStrategy;
import org.spark_project.guava.eventbus.Subscribe;
import org.spark_project.guava.eventbus.SynchronizedEventHandler;
import org.spark_project.guava.reflect.TypeToken;
import org.spark_project.guava.util.concurrent.UncheckedExecutionException;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    private static final LoadingCache<Class<?>, ImmutableList<Method>> handlerMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        @Override
        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return AnnotatedHandlerFinder.getAnnotatedMethodsInternal(concreteClass);
        }
    });

    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap<Class<?>, EventHandler> methodsInListener = HashMultimap.create();
        Class<?> clazz2 = listener.getClass();
        for (Method method : AnnotatedHandlerFinder.getAnnotatedMethods(clazz2)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method);
            methodsInListener.put(eventType, handler);
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz2) {
        try {
            return handlerMethodsCache.getUnchecked(clazz2);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsInternal(Class<?> clazz2) {
        Set supers = TypeToken.of(clazz2).getTypes().rawTypes();
        ImmutableList.Builder result2 = ImmutableList.builder();
        block2: for (Method method : clazz2.getMethods()) {
            for (Class c : supers) {
                try {
                    Method m = c.getMethod(method.getName(), method.getParameterTypes());
                    if (!m.isAnnotationPresent(Subscribe.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> eventType = parameterTypes[0];
                    result2.add(method);
                    continue block2;
                }
                catch (NoSuchMethodException ignored) {
                }
            }
        }
        return result2.build();
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

