/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.Comparator;
import java.util.SortedSet;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Ordering;
import org.spark_project.guava.collect.SortedIterable;

@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements2) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements2);
        if (elements2 instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements2);
        } else if (elements2 instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements2).comparator();
        } else {
            return false;
        }
        return comparator.equals(comparator2);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<E> result2 = sortedSet.comparator();
        if (result2 == null) {
            result2 = Ordering.natural();
        }
        return result2;
    }
}

