/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.Set;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.ImmutableSet;
import org.spark_project.guava.collect.Iterators;
import org.spark_project.guava.collect.ObjectArrays;
import org.spark_project.guava.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;
    private transient int cachedHashCode;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    SingletonImmutableSet(E element, int hashCode2) {
        this.element = element;
        this.cachedHashCode = hashCode2;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        if (array2.length == 0) {
            array2 = ObjectArrays.newArray(array2, 1);
        } else if (array2.length > 1) {
            array2[1] = null;
        }
        T[] objectArray = array2;
        objectArray[0] = this.element;
        return array2;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Set) {
            Set that = (Set)object;
            return that.size() == 1 && this.element.equals(that.iterator().next());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int code2 = this.cachedHashCode;
        if (code2 == 0) {
            this.cachedHashCode = code2 = this.element.hashCode();
        }
        return code2;
    }

    @Override
    boolean isHashCodeFast() {
        return this.cachedHashCode != 0;
    }

    @Override
    public String toString() {
        String elementToString = this.element.toString();
        return new StringBuilder(elementToString.length() + 2).append('[').append(elementToString).append(']').toString();
    }
}

