/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.collect.Hashing;
import org.spark_project.guava.collect.ImmutableSet;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet.ArrayImmutableSet<E> {
    @VisibleForTesting
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] elements2, int hashCode2, Object[] table, int mask) {
        super(elements2);
        this.table = table;
        this.mask = mask;
        this.hashCode = hashCode2;
    }

    @Override
    public boolean contains(Object target) {
        if (target == null) {
            return false;
        }
        int i = Hashing.smear(target.hashCode());
        Object candidate;
        while ((candidate = this.table[i & this.mask]) != null) {
            if (candidate.equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

