/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.Map;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.collect.ImmutableAsList;
import org.spark_project.guava.collect.ImmutableCollection;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.collect.ImmutableMultiset;
import org.spark_project.guava.collect.ImmutableSet;
import org.spark_project.guava.collect.Multiset;
import org.spark_project.guava.collect.Multisets;
import org.spark_project.guava.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map2, int size2) {
        this.map = map2;
        this.size = size2;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@Nullable Object element) {
        Integer value2 = this.map.get(element);
        return value2 == null ? 0 : value2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    private static <E> Multiset.Entry<E> entryFromMapEntry(Map.Entry<E, Integer> entry2) {
        return Multisets.immutableEntry(entry2.getKey(), entry2.getValue());
    }

    @Override
    ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private class EntrySet
    extends ImmutableMultiset.EntrySet {
        private EntrySet() {
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.map.size();
        }

        @Override
        public UnmodifiableIterator<Multiset.Entry<E>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ImmutableList<Multiset.Entry<E>> createAsList() {
            final ImmutableList entryList = ((ImmutableCollection)((Object)RegularImmutableMultiset.this.map.entrySet())).asList();
            return new ImmutableAsList<Multiset.Entry<E>>(){

                @Override
                public Multiset.Entry<E> get(int index) {
                    return RegularImmutableMultiset.entryFromMapEntry((Map.Entry)entryList.get(index));
                }

                @Override
                ImmutableCollection<Multiset.Entry<E>> delegateCollection() {
                    return EntrySet.this;
                }
            };
        }
    }
}

