/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Hashing;
import org.spark_project.guava.collect.ImmutableEntry;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.collect.ImmutableMapEntrySet;
import org.spark_project.guava.collect.ImmutableSet;
import org.spark_project.guava.collect.RegularImmutableAsList;
import org.spark_project.guava.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient LinkedEntry<K, V>[] entries;
    private final transient LinkedEntry<K, V>[] table;
    private final transient int mask;
    private static final double MAX_LOAD_FACTOR = 1.2;
    private static final long serialVersionUID = 0L;

    RegularImmutableMap(Map.Entry<?, ?> ... immutableEntries) {
        int size2 = immutableEntries.length;
        this.entries = this.createEntryArray(size2);
        int tableSize = Hashing.closedTableSize(size2, 1.2);
        this.table = this.createEntryArray(tableSize);
        this.mask = tableSize - 1;
        for (int entryIndex2 = 0; entryIndex2 < size2; ++entryIndex2) {
            LinkedEntry<K, V> existing;
            Map.Entry<?, ?> entry2 = immutableEntries[entryIndex2];
            Object key = entry2.getKey();
            int keyHashCode = key.hashCode();
            int tableIndex = Hashing.smear(keyHashCode) & this.mask;
            LinkedEntry<?, ?> linkedEntry = RegularImmutableMap.newLinkedEntry(key, entry2.getValue(), existing);
            this.table[tableIndex] = linkedEntry;
            this.entries[entryIndex2] = linkedEntry;
            for (existing = this.table[tableIndex]; existing != null; existing = existing.next()) {
                Preconditions.checkArgument(!key.equals(existing.getKey()), "duplicate key: %s", key);
            }
        }
    }

    private LinkedEntry<K, V>[] createEntryArray(int size2) {
        return new LinkedEntry[size2];
    }

    private static <K, V> LinkedEntry<K, V> newLinkedEntry(K key, V value2, @Nullable LinkedEntry<K, V> next2) {
        return (LinkedEntry)((Object)(next2 == null ? new TerminalEntry<K, V>(key, value2) : new NonTerminalEntry<K, V>(key, value2, next2)));
    }

    @Override
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & this.mask;
        for (LinkedEntry<K, V> entry2 = this.table[index]; entry2 != null; entry2 = entry2.next()) {
            Object candidateKey = entry2.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry2.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet();
    }

    private class EntrySet
    extends ImmutableMapEntrySet<K, V> {
        private EntrySet() {
        }

        @Override
        ImmutableMap<K, V> map() {
            return RegularImmutableMap.this;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new RegularImmutableAsList(this, RegularImmutableMap.this.entries);
        }
    }

    @Immutable
    private static final class TerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        TerminalEntry(K key, V value2) {
            super(key, value2);
        }

        @Override
        @Nullable
        public LinkedEntry<K, V> next() {
            return null;
        }
    }

    @Immutable
    private static final class NonTerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        final LinkedEntry<K, V> next;

        NonTerminalEntry(K key, V value2, LinkedEntry<K, V> next2) {
            super(key, value2);
            this.next = next2;
        }

        @Override
        public LinkedEntry<K, V> next() {
            return this.next;
        }
    }

    private static interface LinkedEntry<K, V>
    extends Map.Entry<K, V> {
        @Nullable
        public LinkedEntry<K, V> next();
    }
}

