/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.SortedSet;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Function;
import org.spark_project.guava.base.Predicate;
import org.spark_project.guava.collect.MapMaker;
import org.spark_project.guava.collect.Maps;
import org.spark_project.guava.collect.Sets;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] clone(T[] array2) {
        return (Object[])array2.clone();
    }

    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result2 = (Object[])Array.newInstance(type, length);
        return result2;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static <K, V1, V2> SortedMap<K, V2> mapsTransformEntriesSortedMap(SortedMap<K, V1> fromMap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        return fromMap instanceof NavigableMap ? Maps.transformEntries((NavigableMap)fromMap, transformer) : Maps.transformEntriesIgnoreNavigable(fromMap, transformer);
    }

    static <K, V> SortedMap<K, V> mapsAsMapSortedSet(SortedSet<K> set2, Function<? super K, V> function) {
        return set2 instanceof NavigableSet ? Maps.asMap((NavigableSet)set2, function) : Maps.asMapSortedIgnoreNavigable(set2, function);
    }

    static <E> SortedSet<E> setsFilterSortedSet(SortedSet<E> set2, Predicate<? super E> predicate) {
        return set2 instanceof NavigableSet ? Sets.filter((NavigableSet)set2, predicate) : Sets.filterSortedIgnoreNavigable(set2, predicate);
    }

    static <K, V> SortedMap<K, V> mapsFilterSortedMap(SortedMap<K, V> map2, Predicate<? super Map.Entry<K, V>> predicate) {
        return map2 instanceof NavigableMap ? Maps.filterEntries((NavigableMap)map2, predicate) : Maps.filterSortedIgnoreNavigable(map2, predicate);
    }

    private Platform() {
    }
}

