/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Function;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.AllEqualOrdering;
import org.spark_project.guava.collect.ByFunctionOrdering;
import org.spark_project.guava.collect.ComparatorOrdering;
import org.spark_project.guava.collect.CompoundOrdering;
import org.spark_project.guava.collect.ExplicitOrdering;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.Iterables;
import org.spark_project.guava.collect.LexicographicalOrdering;
import org.spark_project.guava.collect.Lists;
import org.spark_project.guava.collect.MapMaker;
import org.spark_project.guava.collect.NaturalOrdering;
import org.spark_project.guava.collect.NullsFirstOrdering;
import org.spark_project.guava.collect.NullsLastOrdering;
import org.spark_project.guava.collect.ObjectArrays;
import org.spark_project.guava.collect.Platform;
import org.spark_project.guava.collect.ReverseOrdering;
import org.spark_project.guava.collect.UsingToStringOrdering;

@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    public <E extends T> E min(Iterator<E> iterator2) {
        E minSoFar = iterator2.next();
        while (iterator2.hasNext()) {
            minSoFar = this.min(minSoFar, iterator2.next());
        }
        return minSoFar;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    public <E extends T> E min(@Nullable E a, @Nullable E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    public <E extends T> E min(@Nullable E a, @Nullable E b, @Nullable E c, E ... rest2) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest2) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    public <E extends T> E max(Iterator<E> iterator2) {
        E maxSoFar = iterator2.next();
        while (iterator2.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator2.next());
        }
        return maxSoFar;
    }

    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    public <E extends T> E max(@Nullable E a, @Nullable E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public <E extends T> E max(@Nullable E a, @Nullable E b, @Nullable E c, E ... rest2) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest2) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k) {
        Collection collection;
        if (iterable instanceof Collection && (long)(collection = (Collection)iterable).size() <= 2L * (long)k) {
            Object[] array2 = collection.toArray();
            Arrays.sort(array2, this);
            if (array2.length > k) {
                array2 = ObjectArrays.arraysCopyOf(array2, k);
            }
            return Collections.unmodifiableList(Arrays.asList(array2));
        }
        return this.leastOf(iterable.iterator(), k);
    }

    public <E extends T> List<E> leastOf(Iterator<E> elements2, int k) {
        E e;
        Preconditions.checkNotNull(elements2);
        Preconditions.checkArgument(k >= 0, "k (%s) must be nonnegative", k);
        if (k == 0 || !elements2.hasNext()) {
            return ImmutableList.of();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list2 = Lists.newArrayList(elements2);
            Collections.sort(list2, this);
            if (list2.size() > k) {
                list2.subList(k, list2.size()).clear();
            }
            list2.trimToSize();
            return Collections.unmodifiableList(list2);
        }
        int bufferCap = k * 2;
        Object[] buffer = new Object[bufferCap];
        Object threshold = elements2.next();
        buffer[0] = threshold;
        int bufferSize = 1;
        while (bufferSize < k && elements2.hasNext()) {
            e = elements2.next();
            buffer[bufferSize++] = e;
            threshold = this.max(threshold, e);
        }
        while (elements2.hasNext()) {
            e = elements2.next();
            if (this.compare(e, threshold) >= 0) continue;
            buffer[bufferSize++] = e;
            if (bufferSize != bufferCap) continue;
            int left = 0;
            int right = bufferCap - 1;
            int minThresholdPosition = 0;
            while (left < right) {
                int pivotIndex = left + right + 1 >>> 1;
                int pivotNewIndex = this.partition(buffer, left, right, pivotIndex);
                if (pivotNewIndex > k) {
                    right = pivotNewIndex - 1;
                    continue;
                }
                if (pivotNewIndex >= k) break;
                left = Math.max(pivotNewIndex, left + 1);
                minThresholdPosition = pivotNewIndex;
            }
            bufferSize = k;
            threshold = buffer[minThresholdPosition];
            for (int i = minThresholdPosition + 1; i < bufferSize; ++i) {
                threshold = this.max(threshold, buffer[i]);
            }
        }
        Arrays.sort(buffer, 0, bufferSize, this);
        bufferSize = Math.min(bufferSize, k);
        return Collections.unmodifiableList(Arrays.asList(ObjectArrays.arraysCopyOf(buffer, bufferSize)));
    }

    private <E extends T> int partition(E[] values2, int left, int right, int pivotIndex) {
        E pivotValue = values2[pivotIndex];
        values2[pivotIndex] = values2[right];
        values2[right] = pivotValue;
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (this.compare(values2[i], pivotValue) >= 0) continue;
            ObjectArrays.swap(values2, storeIndex, i);
            ++storeIndex;
        }
        ObjectArrays.swap(values2, right, storeIndex);
        return storeIndex;
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k) {
        return this.reverse().leastOf(iterable, k);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator2, int k) {
        return this.reverse().leastOf(iterator2, k);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        Object[] array2 = Iterables.toArray(iterable);
        Arrays.sort(array2, this);
        return Lists.newArrayList(Arrays.asList(array2));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        Object[] elements2;
        for (Object e : elements2 = Iterables.toArray(iterable)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(elements2, this);
        return ImmutableList.asImmutableList(elements2);
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (this.compare(prev, next2) > 0) {
                    return false;
                }
                prev = next2;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (this.compare(prev, next2) >= 0) {
                    return false;
                }
                prev = next2;
            }
        }
        return true;
    }

    public int binarySearch(List<? extends T> sortedList, @Nullable T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value2) {
            super("Cannot compare value: " + value2);
            this.value = value2;
        }
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private Map<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeComputingMap(new Function<Object, Integer>(){
            final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Integer apply(Object from) {
                return this.counter.getAndIncrement();
            }
        });

        ArbitraryOrdering() {
        }

        @Override
        public int compare(Object left, Object right) {
            int rightCode;
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left);
            if (leftCode != (rightCode = this.identityHashCode(right))) {
                return leftCode < rightCode ? -1 : 1;
            }
            int result2 = this.uids.get(left).compareTo(this.uids.get(right));
            if (result2 == 0) {
                throw new AssertionError();
            }
            return result2;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

