/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.annotations.GwtIncompatible;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.DescendingImmutableSortedSet;
import org.spark_project.guava.collect.EmptyImmutableSortedSet;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.ImmutableSet;
import org.spark_project.guava.collect.ImmutableSortedSetFauxverideShim;
import org.spark_project.guava.collect.Iterables;
import org.spark_project.guava.collect.Iterators;
import org.spark_project.guava.collect.Lists;
import org.spark_project.guava.collect.ObjectArrays;
import org.spark_project.guava.collect.Ordering;
import org.spark_project.guava.collect.RegularImmutableSortedSet;
import org.spark_project.guava.collect.SortedIterable;
import org.spark_project.guava.collect.SortedIterables;
import org.spark_project.guava.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements NavigableSet<E>,
SortedIterable<E> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Comparable>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;
    @GwtIncompatible(value="NavigableSet")
    transient ImmutableSortedSet<E> descendingSet;

    private static <E> ImmutableSortedSet<E> emptySet() {
        return NATURAL_EMPTY_SET;
    }

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (NATURAL_ORDER.equals(comparator)) {
            return ImmutableSortedSet.emptySet();
        }
        return new EmptyImmutableSortedSet<E>(comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return ImmutableSortedSet.emptySet();
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E element) {
        return new RegularImmutableSortedSet<E>(ImmutableList.of(element), Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e1, e2));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e1, e2, e3));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e1, e2, e3, e4));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e1, e2, e3, e4, e5));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... remaining) {
        int size2 = remaining.length + 6;
        ArrayList all2 = new ArrayList(size2);
        Collections.addAll(all2, e1, e2, e3, e4, e5, e6);
        Collections.addAll(all2, remaining);
        return ImmutableSortedSet.copyOf(Ordering.natural(), all2);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] elements2) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(elements2));
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> elements2) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements2);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> elements2) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements2);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterator<? extends E> elements2) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements2);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> elements2) {
        return ImmutableSortedSet.copyOf(comparator, Lists.newArrayList(elements2));
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> elements2) {
        ImmutableSortedSet original;
        Preconditions.checkNotNull(comparator);
        boolean hasSameComparator = SortedIterables.hasSameComparator(comparator, elements2);
        if (hasSameComparator && elements2 instanceof ImmutableSortedSet && !(original = (ImmutableSortedSet)elements2).isPartialView()) {
            return original;
        }
        Object[] array2 = Iterables.toArray(elements2);
        return ImmutableSortedSet.construct(comparator, array2.length, array2);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> elements2) {
        return ImmutableSortedSet.copyOf(comparator, elements2);
    }

    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator<E> comparator = SortedIterables.comparator(sortedSet);
        Object[] elements2 = sortedSet.toArray();
        if (elements2.length == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet(ImmutableList.asImmutableList(elements2), comparator);
    }

    static <E> int sortAndUnique(Comparator<? super E> comparator, int n, E ... contents) {
        if (n == 0) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            ObjectArrays.checkElementNotNull(contents[i], i);
        }
        Arrays.sort(contents, 0, n, comparator);
        int uniques = 1;
        for (int i = 1; i < n; ++i) {
            E cur = contents[i];
            E prev = contents[uniques - 1];
            if (comparator.compare(cur, prev) == 0) continue;
            contents[uniques++] = cur;
        }
        Arrays.fill(contents, uniques, n, null);
        return uniques;
    }

    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n, E ... contents) {
        int uniques = ImmutableSortedSet.sortAndUnique(comparator, n, contents);
        if (uniques == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        if (uniques < contents.length) {
            contents = ObjectArrays.arraysCopyOf(contents, uniques);
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(contents), comparator);
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(Object a, Object b) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, a, b);
    }

    static int unsafeCompare(Comparator<?> comparator, Object a, Object b) {
        Comparator<?> unsafeComparator = comparator;
        return unsafeComparator.compare(a, b);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableSortedSet<E> headSet(E toElement) {
        return this.headSet((Object)toElement, false);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        return this.headSetImpl(Preconditions.checkNotNull(toElement), inclusive);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement) {
        return this.tailSet((Object)fromElement, true);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.tailSetImpl(Preconditions.checkNotNull(fromElement), inclusive);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    @GwtIncompatible(value="NavigableSet")
    public E lower(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, false)).descendingIterator(), null);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public E floor(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, true)).descendingIterator(), null);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public E ceiling(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, true), null);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public E higher(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    @GwtIncompatible(value="NavigableSet")
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @GwtIncompatible(value="NavigableSet")
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> result2 = this.descendingSet;
        if (result2 == null) {
            result2 = this.descendingSet = this.createDescendingSet();
            result2.descendingSet = this;
        }
        return result2;
    }

    @GwtIncompatible(value="NavigableSet")
    ImmutableSortedSet<E> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(@Nullable Object var1);

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    private static class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, Object[] elements2) {
            this.comparator = comparator;
            this.elements = elements2;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;

        public Builder(Comparator<? super E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<E> add(E element) {
            super.add((Object)element);
            return this;
        }

        @Override
        public Builder<E> add(E ... elements2) {
            super.add((Object[])elements2);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> elements2) {
            super.addAll((Iterable)elements2);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> elements2) {
            super.addAll((Iterator)elements2);
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            Object[] contentsArray = this.contents;
            ImmutableSortedSet<Object> result2 = ImmutableSortedSet.construct(this.comparator, this.size, contentsArray);
            this.size = result2.size();
            return result2;
        }
    }
}

