/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Collections2;
import org.spark_project.guava.collect.EmptyImmutableSet;
import org.spark_project.guava.collect.Hashing;
import org.spark_project.guava.collect.ImmutableCollection;
import org.spark_project.guava.collect.ImmutableEnumSet;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.ImmutableSortedSet;
import org.spark_project.guava.collect.ObjectArrays;
import org.spark_project.guava.collect.RegularImmutableAsList;
import org.spark_project.guava.collect.RegularImmutableSet;
import org.spark_project.guava.collect.Sets;
import org.spark_project.guava.collect.SingletonImmutableSet;
import org.spark_project.guava.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    static final int MAX_TABLE_SIZE = 0x40000000;
    private static final double DESIRED_LOAD_FACTOR = 0.7;
    private static final int CUTOFF = (int)Math.floor(7.516192768E8);

    public static <E> ImmutableSet<E> of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2) {
        return ImmutableSet.construct(2, e1, e2);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3) {
        return ImmutableSet.construct(3, e1, e2, e3);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableSet.construct(4, e1, e2, e3, e4);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSet.construct(5, e1, e2, e3, e4, e5);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        int paramCount = 6;
        Object[] elements2 = new Object[6 + others.length];
        elements2[0] = e1;
        elements2[1] = e2;
        elements2[2] = e3;
        elements2[3] = e4;
        elements2[4] = e5;
        elements2[5] = e6;
        System.arraycopy(others, 0, elements2, 6, others.length);
        return ImmutableSet.construct(elements2.length, elements2);
    }

    private static <E> ImmutableSet<E> construct(int n, Object ... elements2) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object elem2 = elements2[0];
                return ImmutableSet.of(elem2);
            }
        }
        int tableSize = ImmutableSet.chooseTableSize(n);
        Object[] table = new Object[tableSize];
        int mask = tableSize - 1;
        int hashCode2 = 0;
        int uniques = 0;
        block4: for (int i = 0; i < n; ++i) {
            Object element = ObjectArrays.checkElementNotNull(elements2[i], i);
            int hash2 = element.hashCode();
            int j = Hashing.smear(hash2);
            while (true) {
                int index;
                Object value2;
                if ((value2 = table[index = j & mask]) == null) {
                    elements2[uniques++] = element;
                    table[index] = element;
                    hashCode2 += hash2;
                    continue block4;
                }
                if (value2.equals(element)) continue block4;
                ++j;
            }
        }
        Arrays.fill(elements2, uniques, n, null);
        if (uniques == 1) {
            Object element = elements2[0];
            return new SingletonImmutableSet<Object>(element, hashCode2);
        }
        if (tableSize != ImmutableSet.chooseTableSize(uniques)) {
            return ImmutableSet.construct(uniques, elements2);
        }
        Object[] uniqueElements = uniques < elements2.length ? ObjectArrays.arraysCopyOf(elements2, uniques) : elements2;
        return new RegularImmutableSet(uniqueElements, hashCode2, table, mask);
    }

    @VisibleForTesting
    static int chooseTableSize(int setSize) {
        if (setSize < CUTOFF) {
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return tableSize;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(E[] elements2) {
        switch (elements2.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements2[0]);
            }
        }
        return ImmutableSet.construct(elements2.length, (Object[])elements2.clone());
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> elements2) {
        return elements2 instanceof Collection ? ImmutableSet.copyOf(Collections2.cast(elements2)) : ImmutableSet.copyOf(elements2.iterator());
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> elements2) {
        if (!elements2.hasNext()) {
            return ImmutableSet.of();
        }
        E first = elements2.next();
        if (!elements2.hasNext()) {
            return ImmutableSet.of(first);
        }
        return ((Builder)((Builder)new Builder().add((Object)first)).addAll(elements2)).build();
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> elements2) {
        if (elements2 instanceof ImmutableSet && !(elements2 instanceof ImmutableSortedSet)) {
            ImmutableSet set2 = (ImmutableSet)elements2;
            if (!set2.isPartialView()) {
                return set2;
            }
        } else if (elements2 instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)elements2);
            ImmutableSet result2 = ImmutableEnumSet.asImmutable(enumSet);
            return result2;
        }
        return ImmutableSet.copyFromCollection(elements2);
    }

    private static <E> ImmutableSet<E> copyFromCollection(Collection<? extends E> collection) {
        Object[] elements2 = collection.toArray();
        switch (elements2.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object onlyElement = elements2[0];
                return ImmutableSet.of(onlyElement);
            }
        }
        return ImmutableSet.construct(elements2.length, elements2);
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        Object[] contents;
        int size;

        public Builder() {
            this(4);
        }

        Builder(int capacity) {
            Preconditions.checkArgument(capacity >= 0, "capacity must be >= 0 but was %s", capacity);
            this.contents = new Object[capacity];
            this.size = 0;
        }

        Builder<E> ensureCapacity(int minCapacity) {
            if (this.contents.length < minCapacity) {
                this.contents = ObjectArrays.arraysCopyOf(this.contents, Builder.expandedCapacity(this.contents.length, minCapacity));
            }
            return this;
        }

        @Override
        public Builder<E> add(E element) {
            this.ensureCapacity(this.size + 1);
            this.contents[this.size++] = Preconditions.checkNotNull(element);
            return this;
        }

        @Override
        public Builder<E> add(E ... elements2) {
            for (int i = 0; i < elements2.length; ++i) {
                ObjectArrays.checkElementNotNull(elements2[i], i);
            }
            this.ensureCapacity(this.size + elements2.length);
            System.arraycopy(elements2, 0, this.contents, this.size, elements2.length);
            this.size += elements2.length;
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> elements2) {
            if (elements2 instanceof Collection) {
                Collection collection = (Collection)elements2;
                this.ensureCapacity(this.size + collection.size());
            }
            super.addAll(elements2);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> elements2) {
            super.addAll(elements2);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            ImmutableSet result2 = ImmutableSet.construct(this.size, this.contents);
            this.size = result2.size();
            return result2;
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements2) {
            this.elements = elements2;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }

    static abstract class ArrayImmutableSet<E>
    extends ImmutableSet<E> {
        final transient Object[] elements;

        ArrayImmutableSet(Object[] elements2) {
            this.elements = elements2;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return this.asList().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.asList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array2) {
            return this.asList().toArray(array2);
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            if (targets == this) {
                return true;
            }
            if (!(targets instanceof ArrayImmutableSet)) {
                return super.containsAll(targets);
            }
            if (targets.size() > this.size()) {
                return false;
            }
            for (Object target : ((ArrayImmutableSet)targets).elements) {
                if (this.contains(target)) continue;
                return false;
            }
            return true;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        ImmutableList<E> createAsList() {
            return new RegularImmutableAsList(this, this.elements);
        }
    }
}

