/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.annotations.GwtIncompatible;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.collect.ImmutableSet;

@GwtCompatible(emulated=true)
abstract class ImmutableMapEntrySet<K, V>
extends ImmutableSet<Map.Entry<K, V>> {
    ImmutableMapEntrySet() {
    }

    abstract ImmutableMap<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry2 = (Map.Entry)object;
            V value2 = this.map().get(entry2.getKey());
            return value2 != null && value2.equals(entry2.getValue());
        }
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.map().isPartialView();
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new EntrySetSerializedForm<K, V>(this.map());
    }

    @GwtIncompatible(value="serialization")
    private static class EntrySetSerializedForm<K, V>
    implements Serializable {
        final ImmutableMap<K, V> map;
        private static final long serialVersionUID = 0L;

        EntrySetSerializedForm(ImmutableMap<K, V> map2) {
            this.map = map2;
        }

        Object readResolve() {
            return this.map.entrySet();
        }
    }
}

