/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.Map;
import javax.annotation.Nullable;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.ClassToInstanceMap;
import org.spark_project.guava.collect.ForwardingMap;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.primitives.Primitives;

public final class ImmutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B> {
    private final ImmutableMap<Class<? extends B>, B> delegate;

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public static <B, S extends B> ImmutableClassToInstanceMap<B> copyOf(Map<? extends Class<? extends S>, ? extends S> map2) {
        if (map2 instanceof ImmutableClassToInstanceMap) {
            ImmutableClassToInstanceMap cast2 = (ImmutableClassToInstanceMap)map2;
            return cast2;
        }
        return new Builder().putAll(map2).build();
    }

    private ImmutableClassToInstanceMap(ImmutableMap<Class<? extends B>, B> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected Map<Class<? extends B>, B> delegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public <T extends B> T getInstance(Class<T> type) {
        return (T)this.delegate.get(Preconditions.checkNotNull(type));
    }

    @Override
    @Deprecated
    public <T extends B> T putInstance(Class<T> type, T value2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder<B> {
        private final ImmutableMap.Builder<Class<? extends B>, B> mapBuilder = ImmutableMap.builder();

        public <T extends B> Builder<B> put(Class<T> key, T value2) {
            this.mapBuilder.put(key, value2);
            return this;
        }

        public <T extends B> Builder<B> putAll(Map<? extends Class<? extends T>, ? extends T> map2) {
            for (Map.Entry<Class<T>, T> entry2 : map2.entrySet()) {
                Class<? extends T> type = entry2.getKey();
                T value2 = entry2.getValue();
                this.mapBuilder.put(type, Builder.cast(type, value2));
            }
            return this;
        }

        private static <B, T extends B> T cast(Class<T> type, B value2) {
            return Primitives.wrap(type).cast(value2);
        }

        public ImmutableClassToInstanceMap<B> build() {
            return new ImmutableClassToInstanceMap(this.mapBuilder.build());
        }
    }
}

