/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.base.Predicate;
import org.spark_project.guava.base.Predicates;
import org.spark_project.guava.collect.FilteredMultimap;
import org.spark_project.guava.collect.ForwardingList;
import org.spark_project.guava.collect.ForwardingSet;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.ImmutableSet;
import org.spark_project.guava.collect.Iterators;
import org.spark_project.guava.collect.Maps;
import org.spark_project.guava.collect.Multimap;
import org.spark_project.guava.collect.Multimaps;
import org.spark_project.guava.collect.Multiset;
import org.spark_project.guava.collect.Multisets;
import org.spark_project.guava.collect.SetMultimap;
import org.spark_project.guava.collect.Sets;

@GwtCompatible
class FilteredKeyMultimap<K, V>
extends FilteredMultimap<K, V> {
    final Predicate<? super K> keyPredicate;

    FilteredKeyMultimap(Multimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        super(unfiltered);
        this.keyPredicate = Preconditions.checkNotNull(keyPredicate);
    }

    @Override
    Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return Predicates.compose(this.keyPredicate, Maps.keyFunction());
    }

    @Override
    public int size() {
        int size2 = 0;
        for (Collection collection : this.asMap().values()) {
            size2 += collection.size();
        }
        return size2;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (this.unfiltered.containsKey(key)) {
            Object k = key;
            return this.keyPredicate.apply(k);
        }
        return false;
    }

    @Override
    public Collection<V> removeAll(Object key) {
        return this.containsKey(key) ? this.unfiltered.removeAll(key) : this.unmodifiableEmptyCollection();
    }

    Collection<V> unmodifiableEmptyCollection() {
        if (this.unfiltered instanceof SetMultimap) {
            return ImmutableSet.of();
        }
        return ImmutableList.of();
    }

    @Override
    public void clear() {
        this.keySet().clear();
    }

    @Override
    Set<K> createKeySet() {
        return Sets.filter(this.unfiltered.keySet(), this.keyPredicate);
    }

    @Override
    public Collection<V> get(K key) {
        if (this.keyPredicate.apply(key)) {
            return this.unfiltered.get(key);
        }
        if (this.unfiltered instanceof SetMultimap) {
            return new AddRejectingSet(key);
        }
        return new AddRejectingList(key);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return Iterators.filter(this.unfiltered.entries().iterator(), Predicates.compose(this.keyPredicate, Maps.keyFunction()));
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        return new Multimaps.Entries<K, V>(){

            @Override
            Multimap<K, V> multimap() {
                return FilteredKeyMultimap.this;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return FilteredKeyMultimap.this.entryIterator();
            }

            @Override
            public boolean remove(@Nullable Object o) {
                Map.Entry entry2;
                if (o instanceof Map.Entry && FilteredKeyMultimap.this.unfiltered.containsEntry((entry2 = (Map.Entry)o).getKey(), entry2.getValue()) && FilteredKeyMultimap.this.keyPredicate.apply(entry2.getKey())) {
                    return FilteredKeyMultimap.this.unfiltered.remove(entry2.getKey(), entry2.getValue());
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                Predicate combinedPredicate = Predicates.and(Predicates.compose(FilteredKeyMultimap.this.keyPredicate, Maps.keyFunction()), Predicates.in(c));
                return Iterators.removeIf(FilteredKeyMultimap.this.unfiltered.entries().iterator(), combinedPredicate);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                Predicate combinedPredicate = Predicates.and(Predicates.compose(FilteredKeyMultimap.this.keyPredicate, Maps.keyFunction()), Predicates.not(Predicates.in(c)));
                return Iterators.removeIf(FilteredKeyMultimap.this.unfiltered.entries().iterator(), combinedPredicate);
            }
        };
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return Maps.filterKeys(this.unfiltered.asMap(), this.keyPredicate);
    }

    @Override
    Multiset<K> createKeys() {
        return Multisets.filter(this.unfiltered.keys(), this.keyPredicate);
    }

    static class AddRejectingList<K, V>
    extends ForwardingList<V> {
        final K key;

        AddRejectingList(K key) {
            this.key = key;
        }

        @Override
        public boolean add(V v) {
            this.add(0, v);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            this.addAll(0, collection);
            return true;
        }

        @Override
        public void add(int index, V element) {
            Preconditions.checkPositionIndex(index, 0);
            throw new IllegalArgumentException("Key does not satisfy predicate: " + this.key);
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> elements2) {
            Preconditions.checkNotNull(elements2);
            Preconditions.checkPositionIndex(index, 0);
            throw new IllegalArgumentException("Key does not satisfy predicate: " + this.key);
        }

        @Override
        protected List<V> delegate() {
            return Collections.emptyList();
        }
    }

    static class AddRejectingSet<K, V>
    extends ForwardingSet<V> {
        final K key;

        AddRejectingSet(K key) {
            this.key = key;
        }

        @Override
        public boolean add(V element) {
            throw new IllegalArgumentException("Key does not satisfy predicate: " + this.key);
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            Preconditions.checkNotNull(collection);
            throw new IllegalArgumentException("Key does not satisfy predicate: " + this.key);
        }

        @Override
        protected Set<V> delegate() {
            return Collections.emptySet();
        }
    }
}

