/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.guava.collect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.spark_project.guava.annotations.GwtCompatible;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.ImmutableList;
import org.spark_project.guava.collect.Iterables;
import org.spark_project.guava.collect.Lists;
import org.spark_project.guava.collect.Ordering;

@GwtCompatible(serializable=true)
final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<T> comparator;
    private static final long serialVersionUID = 0L;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public int compare(T a, T b) {
        return this.comparator.compare(a, b);
    }

    @Override
    public int binarySearch(List<? extends T> sortedList, T key) {
        return Collections.binarySearch(sortedList, key, this.comparator);
    }

    @Override
    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> list2 = Lists.newArrayList(iterable);
        Collections.sort(list2, this.comparator);
        return list2;
    }

    @Override
    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        Object[] elements2;
        for (Object e : elements2 = Iterables.toArray(iterable)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(elements2, this.comparator);
        return ImmutableList.asImmutableList(elements2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering that = (ComparatorOrdering)object;
            return this.comparator.equals(that.comparator);
        }
        return false;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return this.comparator.toString();
    }
}

