/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.util;

import java.io.IOException;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.core.JsonpCharacterEscapes;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonSerializable;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.jsontype.TypeSerializer;

public class JSONPObject
implements JsonSerializable {
    protected final String _function;
    protected final Object _value;
    protected final JavaType _serializationType;

    public JSONPObject(String function, Object value2) {
        this(function, value2, null);
    }

    public JSONPObject(String function, Object value2, JavaType asType) {
        this._function = function;
        this._value = value2;
        this._serializationType = asType;
    }

    @Override
    public void serializeWithType(JsonGenerator gen2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(gen2, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(JsonGenerator gen2, SerializerProvider provider) throws IOException {
        gen2.writeRaw(this._function);
        gen2.writeRaw('(');
        if (this._value == null) {
            provider.defaultSerializeNull(gen2);
        } else {
            boolean override;
            boolean bl = override = gen2.getCharacterEscapes() == null;
            if (override) {
                gen2.setCharacterEscapes(JsonpCharacterEscapes.instance());
            }
            try {
                if (this._serializationType != null) {
                    provider.findTypedValueSerializer(this._serializationType, true, null).serialize(this._value, gen2, provider);
                } else {
                    provider.findTypedValueSerializer(this._value.getClass(), true, null).serialize(this._value, gen2, provider);
                }
            }
            finally {
                if (override) {
                    gen2.setCharacterEscapes(null);
                }
            }
        }
        gen2.writeRaw(')');
    }

    public String getFunction() {
        return this._function;
    }

    public Object getValue() {
        return this._value;
    }

    public JavaType getSerializationType() {
        return this._serializationType;
    }
}

