/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import org.spark_project.com.fasterxml.jackson.annotation.JsonFormat;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.core.JsonParser;
import org.spark_project.com.fasterxml.jackson.core.SerializableString;
import org.spark_project.com.fasterxml.jackson.databind.BeanDescription;
import org.spark_project.com.fasterxml.jackson.databind.BeanProperty;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonMappingException;
import org.spark_project.com.fasterxml.jackson.databind.JsonNode;
import org.spark_project.com.fasterxml.jackson.databind.JsonSerializer;
import org.spark_project.com.fasterxml.jackson.databind.SerializationConfig;
import org.spark_project.com.fasterxml.jackson.databind.SerializationFeature;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import org.spark_project.com.fasterxml.jackson.databind.node.ArrayNode;
import org.spark_project.com.fasterxml.jackson.databind.node.ObjectNode;
import org.spark_project.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.spark_project.com.fasterxml.jackson.databind.util.EnumValues;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    public EnumSerializer(EnumValues v, Boolean serializeAsIndex) {
        super(v.getEnumClass(), false);
        this._values = v;
        this._serializeAsIndex = serializeAsIndex;
    }

    public static EnumSerializer construct(Class<?> enumClass, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format2) {
        EnumValues v = EnumValues.constructFromName(config, enumClass);
        Boolean serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(enumClass, format2, true, null);
        return new EnumSerializer(v, serializeAsIndex);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        Class type;
        Boolean serializeAsIndex;
        JsonFormat.Value format2 = this.findFormatOverrides(serializers, property, this.handledType());
        if (format2 != null && (serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(type = this.handledType(), format2, false, this._serializeAsIndex)) != this._serializeAsIndex) {
            return new EnumSerializer(this._values, serializeAsIndex);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator gen2, SerializerProvider serializers) throws IOException {
        if (this._serializeAsIndex(serializers)) {
            gen2.writeNumber(en.ordinal());
            return;
        }
        if (serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            gen2.writeString(en.toString());
            return;
        }
        gen2.writeString(this._values.serializedValueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        JavaType type;
        if (this._serializeAsIndex(provider)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type = provider.constructType(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (SerializableString value2 : this._values.values()) {
                enumNode.add(value2.getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        SerializerProvider serializers = visitor.getProvider();
        if (this._serializeAsIndex(serializers)) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
            return;
        }
        JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
        if (stringVisitor != null) {
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            if (serializers != null && serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                for (Enum<?> e : this._values.enums()) {
                    enums.add(e.toString());
                }
            } else {
                for (SerializableString value2 : this._values.values()) {
                    enums.add(value2.getValue());
                }
            }
            stringVisitor.enumTypes(enums);
        }
    }

    protected final boolean _serializeAsIndex(SerializerProvider serializers) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> enumClass, JsonFormat.Value format2, boolean fromClass, Boolean defaultValue2) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = format2 == null ? null : format2.getShape();
        if (shape == null) {
            return defaultValue2;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return defaultValue2;
        }
        if (shape == JsonFormat.Shape.STRING || shape == JsonFormat.Shape.NATURAL) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric() || shape == JsonFormat.Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(String.format("Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation", new Object[]{shape, enumClass.getName(), fromClass ? "class" : "property"}));
    }
}

