/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.core.JsonToken;
import org.spark_project.com.fasterxml.jackson.core.type.WritableTypeId;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonMappingException;
import org.spark_project.com.fasterxml.jackson.databind.JsonNode;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.spark_project.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.spark_project.com.fasterxml.jackson.databind.node.ObjectNode;
import org.spark_project.com.fasterxml.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value2) {
        return value2.length == 0;
    }

    @Override
    public void serialize(byte[] value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value2, 0, value2.length);
    }

    @Override
    public void serializeWithType(byte[] value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value2, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value2, 0, value2.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

