/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.spark_project.com.fasterxml.jackson.annotation.JsonFormat;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.core.JsonParser;
import org.spark_project.com.fasterxml.jackson.databind.BeanProperty;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonMappingException;
import org.spark_project.com.fasterxml.jackson.databind.JsonNode;
import org.spark_project.com.fasterxml.jackson.databind.JsonSerializer;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.spark_project.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Shape shape;
        JsonFormat.Value format2 = this.findFormatOverrides(serializers, property, Boolean.class);
        if (format2 != null && (shape = format2.getShape()).isNumeric()) {
            return new AsNumber(this._forPrimitive);
        }
        return this;
    }

    @Override
    public void serialize(Object value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBoolean(Boolean.TRUE.equals(value2));
    }

    @Override
    public final void serializeWithType(Object value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.writeBoolean(Boolean.TRUE.equals(value2));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public void serialize(Object value2, JsonGenerator g, SerializerProvider provider) throws IOException {
            g.writeNumber(Boolean.FALSE.equals(value2) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value2, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            g.writeBoolean(Boolean.TRUE.equals(value2));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
            JsonFormat.Shape shape;
            JsonFormat.Value format2 = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format2 != null && !(shape = format2.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }
    }
}

