/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import org.spark_project.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.core.SerializableString;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> generator) {
        this.generator = generator;
    }

    public boolean writeAsId(JsonGenerator gen2, SerializerProvider provider, ObjectIdWriter w) throws IOException {
        if (this.id != null && (this.idWritten || w.alwaysAsId)) {
            if (gen2.canWriteObjectId()) {
                gen2.writeObjectRef(String.valueOf(this.id));
            } else {
                w.serializer.serialize(this.id, gen2, provider);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        if (this.id == null) {
            this.id = this.generator.generateId(forPojo);
        }
        return this.id;
    }

    public void writeAsField(JsonGenerator gen2, SerializerProvider provider, ObjectIdWriter w) throws IOException {
        this.idWritten = true;
        if (gen2.canWriteObjectId()) {
            String idStr = this.id == null ? null : String.valueOf(this.id);
            gen2.writeObjectId(idStr);
            return;
        }
        SerializableString name = w.propertyName;
        if (name != null) {
            gen2.writeFieldName(name);
            w.serializer.serialize(this.id, gen2, provider);
        }
    }
}

