/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.core.JsonToken;
import org.spark_project.com.fasterxml.jackson.core.type.WritableTypeId;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonMappingException;
import org.spark_project.com.fasterxml.jackson.databind.JsonNode;
import org.spark_project.com.fasterxml.jackson.databind.SerializationFeature;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.spark_project.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value2, JsonGenerator gen2, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value2);
        }
        gen2.writeStartObject();
        gen2.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value2, JsonGenerator gen2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value2);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen2, typeSer.typeId(value2, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen2, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value2) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value2) throws JsonMappingException {
        prov.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value2.getClass().getName()));
    }
}

