/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import org.spark_project.com.fasterxml.jackson.annotation.JsonFormat;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.spark_project.com.fasterxml.jackson.databind.BeanProperty;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonMappingException;
import org.spark_project.com.fasterxml.jackson.databind.JsonNode;
import org.spark_project.com.fasterxml.jackson.databind.JsonSerializer;
import org.spark_project.com.fasterxml.jackson.databind.SerializationFeature;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.spark_project.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.spark_project.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.spark_project.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import org.spark_project.com.fasterxml.jackson.databind.type.TypeFactory;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer src, BeanProperty prop, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src, prop, unwrapSingle);
        this._elementSerializer = ser;
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringArraySerializer(this, prop, this._elementSerializer, unwrapSingle);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = null;
        if (property != null) {
            Object serDef;
            AnnotationIntrospector ai = provider.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null && (serDef = ai.findContentSerializer(m)) != null) {
                ser = provider.serializerInstance(m, serDef);
            }
        }
        Boolean unwrapSingle = this.findFormatFeature(provider, property, String[].class, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(provider, property, ser)) == null) {
            ser = provider.findValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            ser = null;
        }
        if (ser == this._elementSerializer && unwrapSingle == this._unwrapSingle) {
            return this;
        }
        return new StringArraySerializer(this, property, ser, unwrapSingle);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, String[] value2) {
        return value2.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] value2) {
        return value2.length == 1;
    }

    @Override
    public final void serialize(String[] value2, JsonGenerator gen2, SerializerProvider provider) throws IOException {
        int len = value2.length;
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value2, gen2, provider);
            return;
        }
        gen2.writeStartArray(len);
        this.serializeContents(value2, gen2, provider);
        gen2.writeEndArray();
    }

    @Override
    public void serializeContents(String[] value2, JsonGenerator gen2, SerializerProvider provider) throws IOException {
        int len = value2.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(value2, gen2, provider, this._elementSerializer);
            return;
        }
        for (int i = 0; i < len; ++i) {
            String str = value2[i];
            if (str == null) {
                gen2.writeNull();
                continue;
            }
            gen2.writeString(value2[i]);
        }
    }

    private void serializeContentsSlow(String[] value2, JsonGenerator gen2, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException {
        int len = value2.length;
        for (int i = 0; i < len; ++i) {
            String str = value2[i];
            if (str == null) {
                provider.defaultSerializeNull(gen2);
                continue;
            }
            ser.serialize(value2[i], gen2, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("string"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitArrayFormat(visitor, typeHint, JsonFormatTypes.STRING);
    }
}

