/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.spark_project.com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import org.spark_project.com.fasterxml.jackson.databind.ser.FilterProvider;
import org.spark_project.com.fasterxml.jackson.databind.ser.PropertyFilter;
import org.spark_project.com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;

public class SimpleFilterProvider
extends FilterProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, PropertyFilter> _filtersById;
    protected PropertyFilter _defaultFilter;
    protected boolean _cfgFailOnUnknownId = true;

    public SimpleFilterProvider() {
        this(new HashMap());
    }

    public SimpleFilterProvider(Map<String, ?> mapping) {
        for (Object ob : mapping.values()) {
            if (ob instanceof PropertyFilter) continue;
            this._filtersById = SimpleFilterProvider._convert(mapping);
            return;
        }
        this._filtersById = mapping;
    }

    private static final Map<String, PropertyFilter> _convert(Map<String, ?> filters) {
        HashMap<String, PropertyFilter> result2 = new HashMap<String, PropertyFilter>();
        for (Map.Entry<String, ?> entry2 : filters.entrySet()) {
            Object f2 = entry2.getValue();
            if (f2 instanceof PropertyFilter) {
                result2.put(entry2.getKey(), (PropertyFilter)f2);
                continue;
            }
            if (f2 instanceof BeanPropertyFilter) {
                result2.put(entry2.getKey(), SimpleFilterProvider._convert((BeanPropertyFilter)f2));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized filter type (" + f2.getClass().getName() + ")");
        }
        return result2;
    }

    private static final PropertyFilter _convert(BeanPropertyFilter f2) {
        return SimpleBeanPropertyFilter.from(f2);
    }

    @Deprecated
    public SimpleFilterProvider setDefaultFilter(BeanPropertyFilter f2) {
        this._defaultFilter = SimpleBeanPropertyFilter.from(f2);
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(PropertyFilter f2) {
        this._defaultFilter = f2;
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(SimpleBeanPropertyFilter f2) {
        this._defaultFilter = f2;
        return this;
    }

    public PropertyFilter getDefaultFilter() {
        return this._defaultFilter;
    }

    public SimpleFilterProvider setFailOnUnknownId(boolean state) {
        this._cfgFailOnUnknownId = state;
        return this;
    }

    public boolean willFailOnUnknownId() {
        return this._cfgFailOnUnknownId;
    }

    @Deprecated
    public SimpleFilterProvider addFilter(String id, BeanPropertyFilter filter2) {
        this._filtersById.put(id, SimpleFilterProvider._convert(filter2));
        return this;
    }

    public SimpleFilterProvider addFilter(String id, PropertyFilter filter2) {
        this._filtersById.put(id, filter2);
        return this;
    }

    public SimpleFilterProvider addFilter(String id, SimpleBeanPropertyFilter filter2) {
        this._filtersById.put(id, filter2);
        return this;
    }

    public PropertyFilter removeFilter(String id) {
        return this._filtersById.remove(id);
    }

    @Override
    @Deprecated
    public BeanPropertyFilter findFilter(Object filterId) {
        throw new UnsupportedOperationException("Access to deprecated filters not supported");
    }

    @Override
    public PropertyFilter findPropertyFilter(Object filterId, Object valueToFilter) {
        PropertyFilter f2 = this._filtersById.get(filterId);
        if (f2 == null && (f2 = this._defaultFilter) == null && this._cfgFailOnUnknownId) {
            throw new IllegalArgumentException("No filter configured with id '" + filterId + "' (type " + filterId.getClass().getName() + ")");
        }
        return f2;
    }
}

