/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.ser;

import java.io.Serializable;
import org.spark_project.com.fasterxml.jackson.annotation.JsonInclude;
import org.spark_project.com.fasterxml.jackson.core.JsonGenerator;
import org.spark_project.com.fasterxml.jackson.databind.JavaType;
import org.spark_project.com.fasterxml.jackson.databind.JsonSerializer;
import org.spark_project.com.fasterxml.jackson.databind.PropertyName;
import org.spark_project.com.fasterxml.jackson.databind.SerializerProvider;
import org.spark_project.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.spark_project.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.spark_project.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import org.spark_project.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.spark_project.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import org.spark_project.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import org.spark_project.com.fasterxml.jackson.databind.util.Annotations;

public abstract class VirtualBeanPropertyWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        this(propDef, contextAnnotations, declaredType, null, null, null, propDef.findInclusion());
    }

    protected VirtualBeanPropertyWriter() {
    }

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, JavaType serType, JsonInclude.Value inclusion2, Class<?>[] includeInViews) {
        super(propDef, propDef.getPrimaryMember(), contextAnnotations, declaredType, ser, typeSer, serType, VirtualBeanPropertyWriter._suppressNulls(inclusion2), VirtualBeanPropertyWriter._suppressableValue(inclusion2), includeInViews);
    }

    @Deprecated
    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, JavaType serType, JsonInclude.Value inclusion2) {
        this(propDef, contextAnnotations, declaredType, ser, typeSer, serType, inclusion2, null);
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter base) {
        super(base);
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter base, PropertyName name) {
        super((BeanPropertyWriter)base, name);
    }

    protected static boolean _suppressNulls(JsonInclude.Value inclusion2) {
        if (inclusion2 == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion2.getValueInclusion();
        return incl != JsonInclude.Include.ALWAYS && incl != JsonInclude.Include.USE_DEFAULTS;
    }

    protected static Object _suppressableValue(JsonInclude.Value inclusion2) {
        if (inclusion2 == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion2.getValueInclusion();
        if (incl == JsonInclude.Include.ALWAYS || incl == JsonInclude.Include.NON_NULL || incl == JsonInclude.Include.USE_DEFAULTS) {
            return null;
        }
        return MARKER_FOR_EMPTY;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    protected abstract Object value(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    public abstract VirtualBeanPropertyWriter withConfig(MapperConfig<?> var1, AnnotatedClass var2, BeanPropertyDefinition var3, JavaType var4);

    @Override
    public void serializeAsField(Object bean, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap m;
        Object value2 = this.value(bean, gen2, prov);
        if (value2 == null) {
            if (this._nullSerializer != null) {
                gen2.writeFieldName(this._name);
                this._nullSerializer.serialize(null, gen2, prov);
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (m = this._dynamicSerializers).serializerFor(cls = value2.getClass())) == null) {
            ser = this._findAndAddDynamic(m, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value2) : this._suppressableValue.equals(value2))) {
            return;
        }
        if (value2 == bean && this._handleSelfReference(bean, gen2, prov, ser)) {
            return;
        }
        gen2.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value2, gen2, prov);
        } else {
            ser.serializeWithType(value2, gen2, prov, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsElement(Object bean, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map2;
        Object value2 = this.value(bean, gen2, prov);
        if (value2 == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, gen2, prov);
            } else {
                gen2.writeNull();
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map2 = this._dynamicSerializers).serializerFor(cls = value2.getClass())) == null) {
            ser = this._findAndAddDynamic(map2, cls, prov);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(prov, value2)) {
                    this.serializeAsPlaceholder(bean, gen2, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value2)) {
                this.serializeAsPlaceholder(bean, gen2, prov);
                return;
            }
        }
        if (value2 == bean && this._handleSelfReference(bean, gen2, prov, ser)) {
            return;
        }
        if (this._typeSerializer == null) {
            ser.serialize(value2, gen2, prov);
        } else {
            ser.serializeWithType(value2, gen2, prov, this._typeSerializer);
        }
    }
}

