/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import org.spark_project.com.fasterxml.jackson.core.JsonProcessingException;
import org.spark_project.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import org.spark_project.com.fasterxml.jackson.databind.deser.SettableBeanProperty;

public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    protected PropertyValue(PropertyValue next2, Object value2) {
        this.next = next2;
        this.value = value2;
    }

    public abstract void assign(Object var1) throws IOException, JsonProcessingException;

    static final class Map
    extends PropertyValue {
        final Object _key;

        public Map(PropertyValue next2, Object value2, Object key) {
            super(next2, value2);
            this._key = key;
        }

        @Override
        public void assign(Object bean) throws IOException, JsonProcessingException {
            ((java.util.Map)bean).put(this._key, this.value);
        }
    }

    static final class Any
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue next2, Object value2, SettableAnyProperty prop, String propName) {
            super(next2, value2);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this._propertyName, this.value);
        }
    }

    static final class Regular
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue next2, Object value2, SettableBeanProperty prop) {
            super(next2, value2);
            this._property = prop;
        }

        @Override
        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this.value);
        }
    }
}

