/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.com.fasterxml.jackson.core.util;

import java.lang.ref.SoftReference;
import org.spark_project.com.fasterxml.jackson.core.io.JsonStringEncoder;
import org.spark_project.com.fasterxml.jackson.core.util.BufferRecycler;
import org.spark_project.com.fasterxml.jackson.core.util.ThreadLocalBufferManager;

public class BufferRecyclers {
    public static final String SYSTEM_PROPERTY_TRACK_REUSABLE_BUFFERS = "org.spark_project.com.fasterxml.jackson.core.util.BufferRecyclers.trackReusableBuffers";
    private static final ThreadLocalBufferManager _bufferRecyclerTracker = "true".equals(System.getProperty("org.spark_project.com.fasterxml.jackson.core.util.BufferRecyclers.trackReusableBuffers")) ? ThreadLocalBufferManager.instance() : null;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _encoderRef = new ThreadLocal();

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref2 = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref2 == null ? null : ref2.get();
        if (br == null) {
            br = new BufferRecycler();
            ref2 = _bufferRecyclerTracker != null ? _bufferRecyclerTracker.wrapAndTrack(br) : new SoftReference<BufferRecycler>(br);
            _recyclerRef.set(ref2);
        }
        return br;
    }

    public static int releaseBuffers() {
        if (_bufferRecyclerTracker != null) {
            return _bufferRecyclerTracker.releaseBuffers();
        }
        return -1;
    }

    public static JsonStringEncoder getJsonStringEncoder() {
        JsonStringEncoder enc;
        SoftReference<JsonStringEncoder> ref2 = _encoderRef.get();
        JsonStringEncoder jsonStringEncoder = enc = ref2 == null ? null : ref2.get();
        if (enc == null) {
            enc = new JsonStringEncoder();
            _encoderRef.set(new SoftReference<JsonStringEncoder>(enc));
        }
        return enc;
    }

    public static byte[] encodeAsUTF8(String text2) {
        return BufferRecyclers.getJsonStringEncoder().encodeAsUTF8(text2);
    }

    public static char[] quoteAsJsonText(String rawText) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsString(rawText);
    }

    public static void quoteAsJsonText(CharSequence input2, StringBuilder output) {
        BufferRecyclers.getJsonStringEncoder().quoteAsString(input2, output);
    }

    public static byte[] quoteAsJsonUTF8(String rawText) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsUTF8(rawText);
    }
}

