/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.iq80.snappy.Memory;

final class SnappyInternalUtils {
    private static final Memory memory;
    static final boolean HAS_UNSAFE;

    private SnappyInternalUtils() {
    }

    static boolean equals(byte[] left, int leftIndex, byte[] right, int rightIndex, int length) {
        SnappyInternalUtils.checkPositionIndexes(leftIndex, leftIndex + length, left.length);
        SnappyInternalUtils.checkPositionIndexes(rightIndex, rightIndex + length, right.length);
        for (int i = 0; i < length; ++i) {
            if (left[leftIndex + i] == right[rightIndex + i]) continue;
            return false;
        }
        return true;
    }

    public static int lookupShort(short[] data, int index) {
        return memory.lookupShort(data, index);
    }

    public static int loadByte(byte[] data, int index) {
        return memory.loadByte(data, index);
    }

    static int loadInt(byte[] data, int index) {
        return memory.loadInt(data, index);
    }

    static void copyLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        memory.copyLong(src, srcIndex, dest, destIndex);
    }

    static long loadLong(byte[] data, int index) {
        return memory.loadLong(data, index);
    }

    static void copyMemory(byte[] input2, int inputIndex, byte[] output, int outputIndex, int length) {
        memory.copyMemory(input2, inputIndex, output, outputIndex, length);
    }

    static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    static void checkPositionIndexes(int start2, int end, int size2) {
        if (start2 < 0 || end < start2 || end > size2) {
            throw new IndexOutOfBoundsException(SnappyInternalUtils.badPositionIndexes(start2, end, size2));
        }
    }

    static String badPositionIndexes(int start2, int end, int size2) {
        if (start2 < 0 || start2 > size2) {
            return SnappyInternalUtils.badPositionIndex(start2, size2, "start index");
        }
        if (end < 0 || end > size2) {
            return SnappyInternalUtils.badPositionIndex(end, size2, "end index");
        }
        return String.format("end index (%s) must not be less than start index (%s)", end, start2);
    }

    static String badPositionIndex(int index, int size2, String desc) {
        if (index < 0) {
            return String.format("%s (%s) must not be negative", desc, index);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        return String.format("%s (%s) must not be greater than size (%s)", desc, index, size2);
    }

    static int readBytes(InputStream source, byte[] dest, int offset, int length) throws IOException {
        int lastRead;
        SnappyInternalUtils.checkNotNull(source, "source is null", new Object[0]);
        SnappyInternalUtils.checkNotNull(dest, "dest is null", new Object[0]);
        int totalRead = lastRead = source.read(dest, offset, length);
        if (lastRead < length) {
            while (totalRead < length && lastRead != -1) {
                lastRead = source.read(dest, offset + totalRead, length - totalRead);
                if (lastRead == -1) continue;
                totalRead += lastRead;
            }
        }
        return totalRead;
    }

    static int skip(InputStream source, int skip) throws IOException {
        if (skip <= 0) {
            return 0;
        }
        int toSkip = skip - (int)source.skip(skip);
        boolean more = true;
        while (toSkip > 0 && more) {
            int read2 = source.read();
            if (read2 == -1) {
                more = false;
                continue;
            }
            --toSkip;
            toSkip = (int)((long)toSkip - source.skip(toSkip));
        }
        int skipped = skip - toSkip;
        return skipped;
    }

    static {
        Memory memoryInstance = null;
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            try {
                Class<Memory> unsafeMemoryClass = SnappyInternalUtils.class.getClassLoader().loadClass("org.iq80.snappy.UnsafeMemory").asSubclass(Memory.class);
                Memory unsafeMemory = unsafeMemoryClass.newInstance();
                if (unsafeMemory.loadInt(new byte[4], 0) == 0) {
                    memoryInstance = unsafeMemory;
                }
            }
            catch (Throwable unsafeMemoryClass) {
                // empty catch block
            }
        }
        if (memoryInstance == null) {
            try {
                Class<Memory> slowMemoryClass = SnappyInternalUtils.class.getClassLoader().loadClass("org.iq80.snappy.SlowMemory").asSubclass(Memory.class);
                Memory slowMemory = slowMemoryClass.newInstance();
                if (slowMemory.loadInt(new byte[4], 0) != 0) {
                    throw new AssertionError((Object)"SlowMemory class is broken!");
                }
                memoryInstance = slowMemory;
            }
            catch (Throwable ignored) {
                throw new AssertionError((Object)"Could not find SlowMemory class");
            }
        }
        memory = memoryInstance;
        HAS_UNSAFE = memory.fastAccessSupported();
    }
}

