/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.leveldbjni.internal;

import org.fusesource.leveldbjni.internal.JniDBIterator;
import org.fusesource.leveldbjni.internal.JniSnapshot;
import org.fusesource.leveldbjni.internal.JniWriteBatch;
import org.fusesource.leveldbjni.internal.NativeCache;
import org.fusesource.leveldbjni.internal.NativeComparator;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.fusesource.leveldbjni.internal.NativeLogger;
import org.fusesource.leveldbjni.internal.NativeRange;
import org.fusesource.leveldbjni.internal.NativeReadOptions;
import org.fusesource.leveldbjni.internal.NativeWriteBatch;
import org.fusesource.leveldbjni.internal.NativeWriteOptions;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;

public class JniDB
implements DB {
    private NativeDB db;
    private NativeCache cache;
    private NativeComparator comparator;
    private NativeLogger logger;

    public JniDB(NativeDB db, NativeCache cache, NativeComparator comparator, NativeLogger logger) {
        this.db = db;
        this.cache = cache;
        this.comparator = comparator;
        this.logger = logger;
    }

    public void close() {
        if (this.db != null) {
            this.db.delete();
            this.db = null;
            if (this.cache != null) {
                this.cache.delete();
                this.cache = null;
            }
            if (this.comparator != null) {
                this.comparator.delete();
                this.comparator = null;
            }
            if (this.logger != null) {
                this.logger.delete();
                this.logger = null;
            }
        }
    }

    public byte[] get(byte[] key) throws DBException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        return this.get(key, new ReadOptions());
    }

    public byte[] get(byte[] key, ReadOptions options2) throws DBException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        try {
            return this.db.get(this.convert(options2), key);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw new DBException(e.getMessage(), e);
        }
    }

    public DBIterator iterator() {
        return this.iterator(new ReadOptions());
    }

    public DBIterator iterator(ReadOptions options2) {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        return new JniDBIterator(this.db.iterator(this.convert(options2)));
    }

    public void put(byte[] key, byte[] value2) throws DBException {
        this.put(key, value2, new WriteOptions());
    }

    public void delete(byte[] key) throws DBException {
        this.delete(key, new WriteOptions());
    }

    public void write(WriteBatch updates) throws DBException {
        this.write(updates, new WriteOptions());
    }

    public WriteBatch createWriteBatch() {
        return new JniWriteBatch(new NativeWriteBatch());
    }

    public Snapshot put(byte[] key, byte[] value2, WriteOptions options2) throws DBException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        try {
            this.db.put(this.convert(options2), key, value2);
            return null;
        }
        catch (NativeDB.DBException e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    public Snapshot delete(byte[] key, WriteOptions options2) throws DBException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        try {
            this.db.delete(this.convert(options2), key);
            return null;
        }
        catch (NativeDB.DBException e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    public Snapshot write(WriteBatch updates, WriteOptions options2) throws DBException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        try {
            this.db.write(this.convert(options2), ((JniWriteBatch)updates).writeBatch());
            return null;
        }
        catch (NativeDB.DBException e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    public Snapshot getSnapshot() {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        return new JniSnapshot(this.db, this.db.getSnapshot());
    }

    public long[] getApproximateSizes(Range ... ranges) {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        NativeRange[] args2 = new NativeRange[ranges.length];
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = new NativeRange(ranges[i].start(), ranges[i].limit());
        }
        return this.db.getApproximateSizes(args2);
    }

    public String getProperty(String name) {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        return this.db.getProperty(name);
    }

    private NativeReadOptions convert(ReadOptions options2) {
        if (options2 == null) {
            return null;
        }
        NativeReadOptions rc = new NativeReadOptions();
        rc.fillCache(options2.fillCache());
        rc.verifyChecksums(options2.verifyChecksums());
        if (options2.snapshot() != null) {
            rc.snapshot(((JniSnapshot)options2.snapshot()).snapshot());
        }
        return rc;
    }

    private NativeWriteOptions convert(WriteOptions options2) {
        if (options2 == null) {
            return null;
        }
        NativeWriteOptions rc = new NativeWriteOptions();
        rc.sync(options2.sync());
        if (options2.snapshot()) {
            throw new UnsupportedOperationException("WriteOptions snapshot not supported");
        }
        return rc;
    }

    public void compactRange(byte[] begin, byte[] end) throws DBException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        this.db.compactRange(begin, end);
    }

    public void suspendCompactions() throws InterruptedException {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        this.db.suspendCompactions();
    }

    public void resumeCompactions() {
        if (this.db == null) {
            throw new DBException("Closed");
        }
        this.db.resumeCompactions();
    }
}

