/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.eclipse.sisu.space.asm.ClassWriter;
import org.eclipse.sisu.space.asm.Label;
import org.eclipse.sisu.space.asm.MethodVisitor;
import org.eclipse.sisu.space.asm.Type;

final class DynamicGlue {
    private static final String PROVIDER_NAME = Type.getInternalName(Provider.class);
    private static final String PROVIDER_DESC = Type.getDescriptor(Provider.class);
    private static final String PROVIDER_HANDLE = "__sisu__";
    private static final String OBJECT_NAME = Type.getInternalName(Object.class);
    private static final String OBJECT_DESC = Type.getDescriptor(Object.class);
    private static final String ILLEGAL_STATE_NAME = Type.getInternalName(IllegalStateException.class);
    private static final Map<String, Method> OBJECT_METHOD_MAP = new HashMap<String, Method>();

    static {
        Method[] methodArray = Object.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (DynamicGlue.isWrappable(m)) {
                OBJECT_METHOD_MAP.put(DynamicGlue.signatureKey(m), m);
            }
            ++n2;
        }
    }

    private DynamicGlue() {
    }

    public static byte[] generateProxyClass(String proxyName, Class<?> facade) {
        String[] apiNames;
        String superName;
        String facadeName = Type.getInternalName(facade);
        if (facade.isInterface()) {
            superName = OBJECT_NAME;
            apiNames = new String[]{facadeName};
        } else {
            superName = facadeName;
            apiNames = DynamicGlue.getInternalNames(facade.getInterfaces());
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 17, proxyName, null, superName, apiNames);
        DynamicGlue.init(cw, superName, proxyName);
        for (Method m : DynamicGlue.getWrappableMethods(facade)) {
            DynamicGlue.wrap(cw, proxyName, m);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void init(ClassWriter cw, String superName, String proxyName) {
        cw.visitField(18, PROVIDER_HANDLE, PROVIDER_DESC, null, null).visitEnd();
        MethodVisitor v = cw.visitMethod(1, "<init>", String.valueOf('(') + PROVIDER_DESC + ")V", null, null);
        v.visitCode();
        v.visitVarInsn(25, 0);
        v.visitInsn(89);
        v.visitVarInsn(25, 1);
        v.visitFieldInsn(181, proxyName, PROVIDER_HANDLE, PROVIDER_DESC);
        v.visitMethodInsn(183, superName, "<init>", "()V", false);
        v.visitInsn(177);
        v.visitMaxs(0, 0);
        v.visitEnd();
    }

    private static void wrap(ClassWriter cw, String proxyName, Method method) {
        int n;
        String methodName = method.getName();
        String descriptor = Type.getMethodDescriptor(method);
        String[] exceptions2 = DynamicGlue.getInternalNames(method.getExceptionTypes());
        Label handleNullTarget = new Label();
        int modifiers = method.getModifiers() & 0xFFFFFADF;
        MethodVisitor v = cw.visitMethod(modifiers, methodName, descriptor, null, exceptions2);
        v.visitCode();
        Class<?> declaringClazz = method.getDeclaringClass();
        String declaringName = Type.getInternalName(declaringClazz);
        boolean isObjectMethod = OBJECT_METHOD_MAP.containsKey(DynamicGlue.signatureKey(method));
        if (!isObjectMethod || "toString".equals(methodName)) {
            v.visitVarInsn(25, 0);
            v.visitFieldInsn(180, proxyName, PROVIDER_HANDLE, PROVIDER_DESC);
            v.visitMethodInsn(185, PROVIDER_NAME, "get", "()" + OBJECT_DESC, true);
            v.visitInsn(89);
            v.visitJumpInsn(198, handleNullTarget);
            boolean isInterface2 = declaringClazz.isInterface();
            if (!isInterface2 && Object.class != declaringClazz) {
                v.visitTypeInsn(192, declaringName);
            }
            int slot = 1;
            Type[] typeArray = Type.getArgumentTypes(method);
            int n2 = typeArray.length;
            n = 0;
            while (n < n2) {
                Type t = typeArray[n];
                v.visitVarInsn(t.getOpcode(21), slot);
                slot += t.getSize();
                ++n;
            }
            int invoke2 = isInterface2 ? 185 : 182;
            v.visitMethodInsn(invoke2, declaringName, methodName, descriptor, isInterface2);
            v.visitInsn(Type.getReturnType(method).getOpcode(172));
            v.visitLabel(handleNullTarget);
            v.visitInsn(87);
            if (!isObjectMethod) {
                v.visitTypeInsn(187, ILLEGAL_STATE_NAME);
                v.visitInsn(89);
                v.visitMethodInsn(183, ILLEGAL_STATE_NAME, "<init>", "()V", false);
                v.visitInsn(191);
            }
        }
        if (isObjectMethod) {
            v.visitVarInsn(25, 0);
            int slot = 1;
            Type[] typeArray = Type.getArgumentTypes(method);
            n = typeArray.length;
            int n3 = 0;
            while (n3 < n) {
                Type t = typeArray[n3];
                v.visitVarInsn(t.getOpcode(21), slot);
                slot += t.getSize();
                ++n3;
            }
            v.visitMethodInsn(183, declaringName, methodName, descriptor, false);
            v.visitInsn(Type.getReturnType(method).getOpcode(172));
        }
        v.visitMaxs(0, 0);
        v.visitEnd();
    }

    private static String[] getInternalNames(Class<?> ... clazzes) {
        String[] names2 = new String[clazzes.length];
        int i = 0;
        while (i < names2.length) {
            names2[i] = Type.getInternalName(clazzes[i]);
            ++i;
        }
        return names2;
    }

    private static Collection<Method> getWrappableMethods(Class<?> clazz2) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>(OBJECT_METHOD_MAP);
        Method[] methodArray = clazz2.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (DynamicGlue.isWrappable(m)) {
                methodMap.put(DynamicGlue.signatureKey(m), m);
            }
            ++n2;
        }
        return methodMap.values();
    }

    private static boolean isWrappable(Method method) {
        return (method.getModifiers() & 0x18) == 0;
    }

    private static String signatureKey(Method method) {
        StringBuilder buf = new StringBuilder(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            buf.append(':').append(t);
            ++n2;
        }
        return buf.toString();
    }
}

