/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space.asm;

import org.eclipse.sisu.space.asm.AnnotationVisitor;
import org.eclipse.sisu.space.asm.Attribute;
import org.eclipse.sisu.space.asm.FieldVisitor;
import org.eclipse.sisu.space.asm.MethodVisitor;
import org.eclipse.sisu.space.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api2) {
        this(api2, null);
    }

    public ClassVisitor(int api2, ClassVisitor cv) {
        if (api2 != 262144 && api2 != 327680) {
            throw new IllegalArgumentException();
        }
        this.api = api2;
        this.cv = cv;
    }

    public void visit(int version, int access2, String name, String signature2, String superName, String[] interfaces2) {
        if (this.cv != null) {
            this.cv.visit(version, access2, name, signature2, superName, interfaces2);
        }
    }

    public void visitSource(String source, String debug2) {
        if (this.cv != null) {
            this.cv.visitSource(source, debug2);
        }
    }

    public void visitOuterClass(String owner2, String name, String desc) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner2, name, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(desc, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        if (this.api < 327680) {
            throw new RuntimeException();
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attr) {
        if (this.cv != null) {
            this.cv.visitAttribute(attr);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName2, int access2) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name, outerName, innerName2, access2);
        }
    }

    public FieldVisitor visitField(int access2, String name, String desc, String signature2, Object value2) {
        if (this.cv != null) {
            return this.cv.visitField(access2, name, desc, signature2, value2);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access2, String name, String desc, String signature2, String[] exceptions2) {
        if (this.cv != null) {
            return this.cv.visitMethod(access2, name, desc, signature2, exceptions2);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

