/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.DefaultClassFinder;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.space.asm.AnnotationVisitor;
import org.eclipse.sisu.space.asm.ClassReader;
import org.eclipse.sisu.space.asm.Type;

public final class SpaceScanner {
    private static final int ASM_FLAGS = 7;
    static final ClassFinder DEFAULT_FINDER = new DefaultClassFinder();
    private final ClassSpace space;
    private final ClassFinder finder;

    public SpaceScanner(ClassSpace space, ClassFinder finder) {
        this.space = space;
        this.finder = finder;
    }

    public SpaceScanner(ClassSpace space) {
        this(space, DEFAULT_FINDER);
    }

    public void accept(SpaceVisitor visitor) {
        visitor.enterSpace(this.space);
        Enumeration<URL> result2 = this.finder.findClasses(this.space);
        while (result2.hasMoreElements()) {
            URL url = result2.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (cv == null) continue;
            SpaceScanner.accept(cv, url);
        }
        visitor.leaveSpace();
    }

    public static void accept(ClassVisitor visitor, URL url) {
        if (url == null) {
            return;
        }
        try {
            InputStream in = url.openStream();
            try {
                new ClassReader(in).accept(SpaceScanner.adapt(visitor), 7);
            }
            finally {
                in.close();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Logs.trace("Problem scanning: {}", url, e);
        }
    }

    public static String jvmDescriptor(Class<? extends Annotation> clazz2) {
        return String.valueOf('L') + clazz2.getName().replace('.', '/') + ';';
    }

    private static org.eclipse.sisu.space.asm.ClassVisitor adapt(final ClassVisitor _cv) {
        return _cv == null ? null : new org.eclipse.sisu.space.asm.ClassVisitor(327680){

            @Override
            public void visit(int version, int access2, String name, String signature2, String superName, String[] interfaces2) {
                _cv.enterClass(access2, name, superName, interfaces2);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final org.eclipse.sisu.space.AnnotationVisitor _av = _cv.visitAnnotation(desc);
                return _av == null ? null : new AnnotationVisitor(327680){
                    {
                        super($anonymous0);
                        annotationVisitor.enterAnnotation();
                    }

                    @Override
                    public void visit(String name, Object value2) {
                        _av.visitElement(name, value2 instanceof Type ? ((Type)value2).getClassName() : value2);
                    }

                    @Override
                    public void visitEnd() {
                        _av.leaveAnnotation();
                    }
                };
            }

            @Override
            public void visitEnd() {
                _cv.leaveClass();
            }
        };
    }
}

