/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import org.eclipse.sisu.space.AbstractDeferredClass;
import org.eclipse.sisu.space.ClassSpace;

final class NamedClass<T>
extends AbstractDeferredClass<T> {
    private final ClassSpace space;
    private final String name;

    NamedClass(ClassSpace space, String name) {
        this.space = space;
        this.name = name;
    }

    @Override
    public Class<T> load() {
        return this.space.loadClass(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return (527 + this.name.hashCode()) * 31 + this.space.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof NamedClass) {
            NamedClass clazz2 = (NamedClass)rhs;
            return this.name.equals(clazz2.name) && this.space.equals(clazz2.space);
        }
        return false;
    }

    public String toString() {
        return "Deferred " + this.name + " from " + this.space;
    }
}

