/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.File;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

final class FileEntryIterator
implements Iterator<String> {
    private final String rootPath;
    private final Deque<String> entryNames = new ArrayDeque<String>();
    private final boolean recurse;

    FileEntryIterator(URL url, String subPath, boolean recurse) {
        this.rootPath = FileEntryIterator.normalizePath(FileEntryIterator.toFile(url).getAbsoluteFile());
        this.recurse = recurse;
        this.appendEntries(subPath);
    }

    @Override
    public boolean hasNext() {
        return this.entryNames.size() > 0;
    }

    @Override
    public String next() {
        String name = this.entryNames.removeFirst();
        if (this.recurse && name.endsWith("/")) {
            this.appendEntries(name);
        }
        return name;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static File toFile(URL url) {
        StringBuilder buf = new StringBuilder();
        String authority = url.getAuthority();
        if (authority != null && authority.length() > 0) {
            buf.append(File.separatorChar).append(File.separatorChar).append(authority);
        }
        String path2 = url.getPath();
        int codePoint = 0;
        int expectBytes = 0;
        int i = 0;
        int length = path2.length();
        while (i < length) {
            char c = path2.charAt(i);
            if ('/' == c) {
                buf.append(File.separatorChar);
            } else if ('%' == c && i < length - 2) {
                int hi2 = Character.digit(path2.charAt(i + 1), 16);
                int lo2 = Character.digit(path2.charAt(i + 2), 16);
                if (hi2 >= 0 && lo2 >= 0) {
                    if (hi2 < 8) {
                        buf.append((char)(hi2 << 4 | lo2));
                    } else if (hi2 >= 12) {
                        expectBytes = 12 == hi2 ? 1 : hi2 - 12;
                        codePoint = (13 == hi2 ? 16 + lo2 : lo2) << 6 * expectBytes;
                    } else if (expectBytes > 0) {
                        codePoint |= ((3 & hi2) << 4 | lo2) << 6 * --expectBytes;
                        if (expectBytes == 0) {
                            buf.appendCodePoint(codePoint);
                        }
                    }
                    i += 2;
                } else {
                    buf.append('%');
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        return new File(buf.toString());
    }

    private void appendEntries(String subPath) {
        File[] listing = new File(String.valueOf(this.rootPath) + subPath).listFiles();
        if (listing != null) {
            File[] fileArray = listing;
            int n = listing.length;
            int n2 = 0;
            while (n2 < n) {
                File f2 = fileArray[n2];
                this.entryNames.add(FileEntryIterator.normalizePath(f2).substring(this.rootPath.length()));
                ++n2;
            }
        }
    }

    private static String normalizePath(File file) {
        return file.toURI().getPath();
    }
}

