/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractSisuIndex {
    static final String INDEX_FOLDER = "META-INF/sisu/";
    static final String QUALIFIER = "javax.inject.Qualifier";
    static final String NAMED = "javax.inject.Named";
    private final Map<Object, Set<String>> index = new LinkedHashMap<Object, Set<String>>();

    AbstractSisuIndex() {
    }

    protected final synchronized void addClassToIndex(Object anno, Object clazz2) {
        Set<String> table = this.index.get(anno);
        if (table == null) {
            table = this.readTable(anno);
            this.index.put(anno, table);
        }
        table.add(String.valueOf(clazz2));
    }

    protected final synchronized void flushIndex() {
        for (Map.Entry<Object, Set<String>> entry2 : this.index.entrySet()) {
            this.writeTable(entry2.getKey(), entry2.getValue());
        }
    }

    protected abstract void info(String var1);

    protected abstract void warn(String var1);

    protected abstract Reader getReader(String var1) throws IOException;

    protected abstract Writer getWriter(String var1) throws IOException;

    private Set<String> readTable(Object name) {
        LinkedHashSet<String> table = new LinkedHashSet<String>();
        try {
            BufferedReader reader = new BufferedReader(this.getReader(INDEX_FOLDER + name));
            try {
                String line2 = reader.readLine();
                while (line2 != null) {
                    table.add(line2);
                    line2 = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return table;
    }

    private void writeTable(Object name, Set<String> table) {
        try {
            BufferedWriter writer = new BufferedWriter(this.getWriter(INDEX_FOLDER + name));
            try {
                for (String line2 : table) {
                    writer.write(line2);
                    writer.newLine();
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.warn(e.toString());
        }
    }
}

